<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var dataX = 0;
    var dataY = 0;
    var dataZ = 0;
    var yIndex = 0;
    var y = 0;
    var xIndex = 0;
    var x = 0;
    var perspective = 0;
    var c = 0;

    // The x and y coordinates of the grid
    dataX = Array(0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0);
    dataY = Array(0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0);

    // The values at the grid points. In this example, we will compute the values
    // using the formula z = sin((x - 0.5) * 2 * pi) * sin((y - 0.5) * 2 * pi)
    dataZ = ArrayNew(1);
    for (yIndex = 0; yIndex LT ArrayLen(dataY); yIndex = yIndex + 1) {
        y = (dataY[yIndex + 1] - 0.5) * 2 * 3.1416;
        for (xIndex = 0; xIndex LT ArrayLen(dataX); xIndex = xIndex + 1) {
            x = (dataX[xIndex + 1] - 0.5) * 2 * 3.1416;
            dataZ[yIndex * ArrayLen(dataX) + xIndex + 1] = Sin(x) * Sin(y);
        }
    }

    // the perspective level
    perspective = Int(img) * 12;

    // Create a SurfaceChart object of size 360 x 360 pixels, with white (ffffff)
    // background and grey (888888) border.
    c = cd.SurfaceChart(360, 360, "0xffffff", "0x888888");

    // Set the perspective level
    c.setPerspective(perspective);
    c.addTitle("Perspective = " & perspective);

    // Set the center of the plot region at (195, 165), and set width x depth x
    // height to 200 x 200 x 150 pixels
    c.setPlotRegion(195, 165, 200, 200, 150);

    // Set the plot region wall thichness to 5 pixels
    c.setWallThickness(5);

    // Set the elevation and rotation angles to 30 and 30 degrees
    c.setViewAngle(30, 30);

    // Set the data to use to plot the chart
    c.setData(dataX, dataY, dataZ);

    // Spline interpolate data to a 40 x 40 grid for a smooth surface
    c.setInterpolation(40, 40);

    // Use smooth gradient coloring.
    c.colorAxis().setColorGradient();

    // Output the chart
    return c.makeSession(GetPageContext(), "chart" & img, cd.JPG);
}

chart0URL = createChart(0);
chart1URL = createChart(1);
chart2URL = createChart(2);
chart3URL = createChart(3);
chart4URL = createChart(4);
chart5URL = createChart(5);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Surface Perspective
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0URL#" />
<img src="getchart.cfm?#chart1URL#" />
<img src="getchart.cfm?#chart2URL#" />
<img src="getchart.cfm?#chart3URL#" />
<img src="getchart.cfm?#chart4URL#" />
<img src="getchart.cfm?#chart5URL#" />
</cfoutput>
</body>
</html>
