<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The x and y coordinates of the grid
dataX = Array(-10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10);
dataY = Array(-10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10);

// The values at the grid points. In this example, we will compute the values using
// the formula z = x * sin(y) + y * sin(x).
dataZ = ArrayNew(1);
for (yIndex = 0; yIndex LT ArrayLen(dataY); yIndex = yIndex + 1) {
    y = dataY[yIndex + 1];
    for (xIndex = 0; xIndex LT ArrayLen(dataX); xIndex = xIndex + 1) {
        x = dataX[xIndex + 1];
        dataZ[yIndex * ArrayLen(dataX) + xIndex + 1] = x * Sin(y) + y * Sin(x);
    }
}

// Create a SurfaceChart object of size 720 x 600 pixels
c = cd.SurfaceChart(720, 600);

// Add a title to the chart using 20 points Times New Roman Italic font
c.addTitle("Surface Energy Density   ", "Times New Roman Italic", 20);

// Set the center of the plot region at (350, 280), and set width x depth x height to
// 360 x 360 x 270 pixels
c.setPlotRegion(350, 280, 360, 360, 270);

// Set the data to use to plot the chart
c.setData(dataX, dataY, dataZ);

// Spline interpolate data to a 80 x 80 grid for a smooth surface
c.setInterpolation(80, 80);

// Add a color axis (the legend) in which the left center is anchored at (645, 270).
// Set the length to 200 pixels and the labels on the right side.
c.setColorAxis(645, 270, cd.Left, 200, cd.Right);

// Set the x, y and z axis titles using 10 points Arial Bold font
c.xAxis().setTitle("X (nm)", "Arial Bold", 10);
c.yAxis().setTitle("Y (nm)", "Arial Bold", 10);
c.zAxis().setTitle("Energy Density (J/m<*font,super*>2<*/font*>)", "Arial Bold", 10);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1", cd.JPG);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Surface Chart (1)
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" />
</cfoutput>
</body>
</html>
