<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the chart
dataY0 = Array(4, 4.5, 5, 5.25, 5.75, 5.25, 5, 4.5, 4, 3, 2.5, 2.5);
dataX0 = Array(CreateDate(1997, 1, 1), CreateDate(1998, 6, 25), CreateDate(1999, 9, 6
    ), CreateDate(2000, 2, 6), CreateDate(2000, 9, 21), CreateDate(2001, 3, 4),
    CreateDate(2001, 6, 8), CreateDate(2002, 2, 4), CreateDate(2002, 5, 19),
    CreateDate(2002, 8, 16), CreateDate(2002, 12, 1), CreateDate(2003, 1, 1));

dataY1 = Array(7, 6.5, 6, 5, 6.5, 7, 6, 5.5, 5, 4, 3.5, 3.5);
dataX1 = Array(CreateDate(1997, 1, 1), CreateDate(1997, 7, 1), CreateDate(1997, 12, 1
    ), CreateDate(1999, 1, 15), CreateDate(1999, 6, 9), CreateDate(2000, 3, 3),
    CreateDate(2000, 8, 13), CreateDate(2001, 5, 5), CreateDate(2001, 9, 16),
    CreateDate(2002, 3, 16), CreateDate(2002, 6, 1), CreateDate(2003, 1, 1));

// Create a XYChart object of size 500 x 270 pixels, with a pale blue (e0e0ff)
// background, black border, 1 pixel 3D border effect and rounded corners
c = cd.XYChart(600, 300, "0xe0e0ff", "0x000000", 1);
c.setRoundedFrame();

// Set the plotarea at (55, 60) and of size 520 x 200 pixels, with white (ffffff)
// background. Set horizontal and vertical grid lines to grey (cccccc).
c.setPlotArea(50, 60, 525, 200, "0xffffff", -1, -1, "0xcccccc", "0xcccccc");

// Add a legend box at (55, 32) (top of the chart) with horizontal layout. Use 9 pts
// Arial Bold font. Set the background and border color to Transparent.
c.addLegend(55, 32, False, "Arial Bold", 9).setBackground(cd.Transparent);

// Add a title box to the chart using 15 pts Times Bold Italic font. The text is
// white (ffffff) on a deep blue (000088) background, with soft lighting effect from
// the right side.
c.addTitle("Long Term Interest Rates", "Times New Roman Bold Italic", 15, "0xffffff"
    ).setBackground("0x000088", -1, cd.softLighting(cd.Right));

// Set the y axis label format to display a percentage sign
c.yAxis().setLabelFormat("{value}%");

// Add a red (ff0000) step line layer to the chart and set the line width to 2 pixels
layer0 = c.addStepLineLayer(dataY0, "0xff0000", "Country AAA");
layer0.setXData(dataX0);
layer0.setLineWidth(2);

// Add a blue (0000ff) step line layer to the chart and set the line width to 2
// pixels
layer1 = c.addStepLineLayer(dataY1, "0x0000ff", "Country BBB");
layer1.setXData(dataX1);
layer1.setLineWidth(2);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{dataSetName} change to {value}% on {x|mmm dd, yyyy}'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Step Line Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
