<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Data for the chart
data0 = Array(5, 3, 10, 4, 3, 5, 2, 5);
data1 = Array(12, 6, 17, 6, 7, 9, 4, 7);
data2 = Array(17, 7, 22, 7, 18, 13, 5, 11);

angles = Array(0, 45, 90, 135, 180, 225, 270, 315);
labels = Array("North", "North<*br*>East", "East", "South<*br*>East", "South",
    "South<*br*>West", "West", "North<*br*>West");

// Create a PolarChart object of size 460 x 500 pixels, with a grey (e0e0e0)
// background and a 1 pixel 3D border
c = cd.PolarChart(460, 500, "0xe0e0e0", "0x000000", 1);

// Add a title to the chart at the top left corner using 15pts Arial Bold Italic
// font. Use white text on deep blue background.
c.addTitle("Wind Direction", "Arial Bold Italic", 15, "0xffffff").setBackground(
    "0x000080");

legendBox = c.addLegend(230, 35, False, "Arial Bold", 9);
legendBox.setAlignment(cd.TopCenter);
legendBox.setBackground(cd.Transparent, cd.Transparent, 1);

legendBox.addKey("5 m/s or above", "0xff3333");
legendBox.addKey("1 - 5 m/s", "0x33ff33");
legendBox.addKey("less than 1 m/s", "0x3333ff");

// Set plot area center at (230, 280) with radius 180 pixels and white background
c.setPlotArea(230, 280, 180, "0xffffff");

// Set the grid style to circular grid
c.setGridStyle(False);

// Set angular axis as 0 - 360, with a spoke every 30 units
c.angularAxis().setLinearScale2(0, 360, labels);

for (i = 0; i LT ArrayLen(angles); i = i + 1) {
    c.angularAxis().addZone(angles[i + 1] - 10, angles[i + 1] + 10, 0, data0[i + 1],
        "0x3333ff", 0);
    c.angularAxis().addZone(angles[i + 1] - 10, angles[i + 1] + 10, data0[i + 1],
        data1[i + 1], "0x33ff33", 0);
    c.angularAxis().addZone(angles[i + 1] - 10, angles[i + 1] + 10, data1[i + 1],
        data2[i + 1], "0xff3333", 0);
}

// Add an Transparent invisible layer to ensure the axis is auto-scaled using the
// data
c.addLineLayer(data2, cd.Transparent);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Stacked Rose Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" />
</cfoutput>
</body>
</html>
