<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the chart
data0 = Array(32, 39, 23, 28, 41, 38, 26, 35, 29);
data1 = Array(50, 55, 47, 34, 47, 53, 38, 40, 51);

// The labels for the chart
labels = Array("0", "1", "2", "3", "4", "5", "6", "7", "8");

// Create a XYChart object of size 600 x 300 pixels, with a pale red (ffdddd)
// background, black border, 1 pixel 3D border effect and rounded corners.
c = cd.XYChart(600, 300, "0xffdddd", "0x000000", 1);
c.setRoundedFrame();

// Set search path to current directory for loading icon images
c.setSearchPath(GetPageContext());

// Set the plotarea at (55, 58) and of size 520 x 195 pixels, with white (ffffff)
// background. Set horizontal and vertical grid lines to grey (cccccc).
c.setPlotArea(55, 58, 520, 195, "0xffffff", -1, -1, "0xcccccc", "0xcccccc");

// Add a legend box at (55, 32) (top of the chart) with horizontal layout. Use 9 pts
// Arial Bold font. Set the background and border color to Transparent.
c.addLegend(55, 32, False, "Arial Bold", 9).setBackground(cd.Transparent);

// Add a title box to the chart using 15 pts Times Bold Italic font. The title is in
// CDML and includes embedded images for highlight. The text is white (ffffff) on a
// dark red (880000) background, with soft lighting effect from the right side.
c.addTitle(
    "<*block,valign=absmiddle*><*img=star.png*><*img=star.png*> Performance " &
    "Enhancer <*img=star.png*><*img=star.png*><*/*>", "Times New Roman Bold Italic",
    15, "0xffffff").setBackground("0x880000", -1, cd.softLighting(cd.Right));

// Add a title to the y axis
c.yAxis().setTitle("Energy Concentration (KJ per liter)");

// Set the labels on the x axis
c.xAxis().setLabels(labels);

// Add a title to the x axis using CMDL
c.xAxis().setTitle(
    "<*block,valign=absmiddle*><*img=clock.png*>  Elapsed Time (hour)<*/*>");

// Set the axes width to 2 pixels
c.xAxis().setWidth(2);
c.yAxis().setWidth(2);

// Add a spline layer to the chart
layer = c.addSplineLayer();

// Set the default line width to 2 pixels
layer.setLineWidth(2);

// Add a data set to the spline layer, using blue (0000c0) as the line color, with
// yellow (ffff00) circle symbols.
layer.addDataSet(data1, "0x0000c0", "Target Group").setDataSymbol(cd.CircleSymbol, 9,
    "0xffff00");

// Add a data set to the spline layer, using brown (982810) as the line color, with
// pink (f040f0) diamond symbols.
layer.addDataSet(data0, "0x982810", "Control Group").setDataSymbol(cd.DiamondSymbol,
    11, "0xf040f0");

// Add a custom CDML text at the bottom right of the plot area as the logo
c.addText(575, 250,
    "<*block,valign=absmiddle*><*img=small_molecule.png*> <*block*><*font=Times " &
    "New Roman Bold Italic,size=10,color=804040*>Molecular<*br*>Engineering<*/*>"
    ).setAlignment(cd.BottomRight);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{dataSetName} at t = {xLabel} hour: {value} KJ/liter'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Spline Line Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
