<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the bar chart
data0 = Array(100, 125, 245, 147, 67);
data1 = Array(85, 156, 179, 211, 123);
data2 = Array(97, 87, 56, 267, 157);
labels = Array("Mon", "Tue", "Wed", "Thur", "Fri");

// Create a XYChart object of size 540 x 375 pixels
c = cd.XYChart(540, 375);

// Add a title to the chart using 18 pts Times Bold Italic font
c.addTitle("Average Weekly Network Load", "Times New Roman Bold Italic", 18);

// Set the plotarea at (50, 55) and of 440 x 280 pixels in size. Use a vertical
// gradient color from light red (ffdddd) to dark red (880000) as background. Set
// border and grid lines to white (ffffff).
c.setPlotArea(50, 55, 440, 280, c.linearGradientColor(0, 55, 0, 335, "0xffdddd",
    "0x880000"), -1, "0xffffff", "0xffffff");

// Add a legend box at (50, 25) using horizontal layout. Use 10pts Arial Bold as
// font, with transparent background.
c.addLegend(50, 25, False, "Arial Bold", 10).setBackground(cd.Transparent);

// Set the x axis labels
c.xAxis().setLabels(labels);

// Draw the ticks between label positions (instead of at label positions)
c.xAxis().setTickOffset(0.5);

// Set axis label style to 8pts Arial Bold
c.xAxis().setLabelStyle("Arial Bold", 8);
c.yAxis().setLabelStyle("Arial Bold", 8);

// Set axis line width to 2 pixels
c.xAxis().setWidth(2);
c.yAxis().setWidth(2);

// Add axis title
c.yAxis().setTitle("Throughput (MBytes Per Hour)");

// Add a multi-bar layer with 3 data sets and 4 pixels 3D depth
layer = c.addBarLayer2(cd.Side, 4);
layer.addDataSet(data0, "0xffff00", "Server ##1");
layer.addDataSet(data1, "0x00ff00", "Server ##2");
layer.addDataSet(data2, "0x9999ff", "Server ##3");

// Set bar border to transparent. Use soft lighting effect with light direction from
// top.
layer.setBorderColor(cd.Transparent, cd.softLighting(cd.Top));

// Configure the bars within a group to touch each others (no gap)
layer.setBarGap(0.2, cd.TouchBar);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{dataSetName} on {xLabel}: {value} MBytes/hour'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Soft Multi-Bar Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
