<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the pyramid chart
data = Array(156, 123, 211, 179);

// The labels for the pyramid chart
labels = Array("Funds", "Bonds", "Stocks", "Cash");

// Create a PyramidChart object of size 360 x 360 pixels
c = cd.PyramidChart(360, 360);

// Set the pyramid center at (180, 180), and width x height to 150 x 180 pixels
c.setPyramidSize(180, 180, 150, 300);

// Set the pyramid data and labels
c.setData(data, labels);

// Add labels at the center of the pyramid layers using Arial Bold font. The labels
// will have two lines showing the layer name and percentage.
c.setCenterLabel("{label}<*br*>{percent}%", "Arial Bold");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='{label}: US$ {value}M ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Simple Pyramid Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
