<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the pie chart
data = Array(35, 30, 25, 7, 6, 5, 4, 3, 2, 1);

// The labels for the pie chart
labels = Array("Labor", "Production", "Facilities", "Taxes", "Misc", "Legal",
    "Insurance", "Licenses", "Transport", "Interest");

// Create a PieChart object of size 560 x 270 pixels, with a golden background and a
// 1 pixel 3D border
c = cd.PieChart(560, 270, cd.goldColor(), -1, 1);

// Add a title box using 15 pts Times Bold Italic font and metallic pink background
// color
c.addTitle("Project Cost Breakdown", "Times New Roman Bold Italic", 15
    ).setBackground(cd.metalColor("0xff9999"));

// Set the center of the pie at (280, 135) and the radius to 110 pixels
c.setPieSize(280, 135, 110);

// Draw the pie in 3D with 20 pixels 3D depth
c.set3D(20);

// Use the side label layout method
c.setLabelLayout(cd.SideLayout);

// Set the label box background color the same as the sector color, with glass
// effect, and with 5 pixels rounded corners
t = c.setLabelStyle();
t.setBackground(cd.SameAsMainColor, cd.Transparent, cd.glassEffect());
t.setRoundedCorners(5);

// Set the border color of the sector the same color as the fill color. Set the line
// color of the join line to black (0x0)
c.setLineColor(cd.SameAsMainColor, "0x000000");

// Set the start angle to 135 degrees may improve layout when there are many small
// sectors at the end of the data array (that is, data sorted in descending order).
// It is because this makes the small sectors position near the horizontal axis,
// where the text label has the least tendency to overlap. For data sorted in
// ascending order, a start angle of 45 degrees can be used instead.
c.setStartAngle(135);

// Set the pie data and the pie labels
c.setData(data, labels);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='{label}: US${value}K ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Side Label Layout
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
