<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The XY points for the scatter chart
dataX = Array(200, 400, 300, 250, 500);
dataY = Array(40, 100, 50, 150, 250);

// The custom symbols for the points
symbols = Array("robot1.png", "robot2.png", "robot3.png", "robot4.png", "robot5.png")
    ;

// Create a XYChart object of size 450 x 400 pixels
c = cd.XYChart(450, 400);

// Set search path to current directory for loading icon images
c.setSearchPath(GetPageContext());

// Set the plotarea at (55, 40) and of size 350 x 300 pixels, with a light grey
// border (0xc0c0c0). Turn on both horizontal and vertical grid lines with light grey
// color (0xc0c0c0)
c.setPlotArea(55, 40, 350, 300, -1, -1, "0xc0c0c0", "0xc0c0c0", -1);

// Add a title to the chart using 18 pts Times Bold Itatic font.
c.addTitle("Battle Robots", "Times New Roman Bold Italic", 18);

// Add a title to the y axis using 12 pts Arial Bold Italic font
c.yAxis().setTitle("Speed (km/s)", "Arial Bold Italic", 12);

// Add a title to the y axis using 12 pts Arial Bold Italic font
c.xAxis().setTitle("Range (km)", "Arial Bold Italic", 12);

// Set the axes line width to 3 pixels
c.xAxis().setWidth(3);
c.yAxis().setWidth(3);

// Add each point of the data as a separate scatter layer, so that they can have a
// different symbol
for (i = 0; i LT ArrayLen(dataX); i = i + 1) {
    c.addScatterLayer(Array(dataX[i + 1]), Array(dataY[i + 1])).getDataSet(0
        ).setDataSymbol2(symbols[i + 1]);
}

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='Range = {x} km, Speed = {value} km/s'")
    ;

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Custom Scatter Symbols
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
