<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the area chart
data = Array(30, 28, 40, 55, 75, 68, 54, 60, 50, 62, 75, 65, 75, 89, 60, 55, 53, 35,
    50, 66, 56, 48, 52, 65, 62);

// The labels for the area chart
labels = Array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24);

// Create a XYChart object of size 320 x 320 pixels
c = cd.XYChart(320, 320);

// Swap the x and y axis to become a rotated chart
c.swapXY();

// Set the y axis on the top side (right + rotated = top)
c.setYAxisOnRight();

// Reverse the x axis so it is pointing downwards
c.xAxis().setReverse();

// Set the plotarea at (50, 50) and of size 200 x 200 pixels. Enable horizontal and
// vertical grids by setting their colors to grey (0xc0c0c0).
c.setPlotArea(50, 50, 250, 250).setGridColor("0xc0c0c0", "0xc0c0c0");

// Add a line chart layer using the given data
c.addAreaLayer(data, c.gradientColor(50, 0, 300, 0, "0xffffff", "0x0000ff"));

// Set the labels on the x axis. Append "m" after the value to show the unit.
c.xAxis().setLabels2(labels, "{value} m");

// Display 1 out of 3 labels.
c.xAxis().setLabelStep(3);

// Add a title to the x axis
c.xAxis().setTitle("Depth");

// Add a title to the y axis
c.yAxis().setTitle("Carbon Dioxide Concentration (ppm)");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='Carbon dioxide concentration at {xLabel}: {value} ppm'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Rotated Area Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
