<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

//
// Data to draw the chart. In this demo, the data buffer will be filled by a random
// data generator. In real life, the data is probably stored in a buffer (eg. a
// database table, a text file, or some global memory) and updated by other means.
//

// We use a data buffer to emulate the last 240 samples.
sampleSize = 240;
dataSeries1 = ArrayNew(1);
dataSeries2 = ArrayNew(1);
dataSeries3 = ArrayNew(1);
timeStamps = ArrayNew(1);

// Our pseudo random number generator
firstDate = DateAdd("s",  - sampleSize, Now());
for (i = 0; i LT sampleSize; i = i + 1) {
    timeStamps[i + 1] = DateAdd("s", i, firstDate);
    p = Second(timeStamps[i + 1]) + Minute(timeStamps[i + 1]) * 60 + Hour(timeStamps[
        i + 1]) * 3600;
    dataSeries1[i + 1] = Cos(p * 7 * 18463) * 10 + 1 / (Cos(p) * Cos(p) + 0.01) + 20;
    dataSeries2[i + 1] = 100 * Sin(p / 27.7) * Sin(p / 10.1) + 150;
    dataSeries3[i + 1] = 100 * Cos(p / 6.7) * Cos(p / 11.9) + 150;
}

// Create an XYChart object 600 x 270 pixels in size, with light grey (f4f4f4)
// background, black (000000) border, 1 pixel raised effect, and with a rounded
// frame.
c = cd.XYChart(600, 270, "0xf4f4f4", "0x000000", 0);
c.setRoundedFrame();

// Set the plotarea at (55, 62) and of size 520 x 175 pixels. Use white (ffffff)
// background. Enable both horizontal and vertical grids by setting their colors to
// grey (cccccc). Set clipping mode to clip the data lines to the plot area.
c.setPlotArea(55, 62, 520, 175, "0xffffff", -1, -1, "0xcccccc", "0xcccccc");
c.setClipping();

// Add a title to the chart using 15 pts Times New Roman Bold Italic font, with a
// light grey (dddddd) background, black (000000) border, and a glass like raised
// effect.
c.addTitle("Zooming and Scrolling Demonstration", "Times New Roman Bold Italic", 15
    ).setBackground("0xdddddd", "0x000000", cd.glassEffect());

// Add a legend box at the top of the plot area with 9pts Arial Bold font. We set the
// legend box to the same width as the plot area and use grid layout (as opposed to
// flow or top/down layout). This distributes the 3 legend icons evenly on top of the
// plot area.
b = c.addLegend2(55, 33, 3, "Arial Bold", 9);
b.setBackground(cd.Transparent, cd.Transparent);
b.setWidth(520);

// Configure the y-axis with a 10pts Arial Bold axis title
c.yAxis().setTitle("Price (USD)", "Arial Bold", 10);

// Configure the x-axis to auto-scale with at least 75 pixels between major tick and
// 15 pixels between minor ticks. This shows more minor grid lines on the chart.
c.xAxis().setTickDensity(75, 15);

// Set the axes width to 2 pixels
c.xAxis().setWidth(2);
c.yAxis().setWidth(2);

// Set the x-axis label format
c.xAxis().setLabelFormat("{value|hh:nn:ss}");

// Create a line layer to plot the lines
layer = c.addLineLayer2();

// The x-coordinates are the timeStamps.
layer.setXData(timeStamps);

// The 3 data series are used to draw 3 lines. Here we put the latest data values as
// part of the data set name, so you can see them updated in the legend box.
layer.addDataSet(dataSeries1, "0xff0000", c.formatValue(dataSeries1[ArrayLen(
    dataSeries1)], "Software: <*bgColor=FFCCCC*> {value|2} "));
layer.addDataSet(dataSeries2, "0x00cc00", c.formatValue(dataSeries2[ArrayLen(
    dataSeries2)], "Hardware: <*bgColor=CCFFCC*> {value|2} "));
layer.addDataSet(dataSeries3, "0x0000ff", c.formatValue(dataSeries3[ArrayLen(
    dataSeries3)], "Services: <*bgColor=CCCCFF*> {value|2} "));

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Stream chart directly to browser
GetPageContext().forward("getchart.cfm?" & chart1URL);

</cfscript>
