<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var data = 0;
    var colors = 0;
    var angle = 0;
    var c = 0;

    // The data for the pyramid chart
    data = Array(156, 123, 211, 179);

    // The colors for the pyramid layers
    colors = Array("0x66aaee", "0xeebb22", "0xcccccc", "0xcc88ff");

    // The elevation angle
    angle = Int(img) * 15;

    // Create a PyramidChart object of size 200 x 200 pixels, with white (ffffff)
    // background and grey (888888) border
    c = cd.PyramidChart(200, 200, "0xffffff", "0x888888");

    // Set the pyramid center at (100, 100), and width x height to 60 x 120 pixels
    c.setPyramidSize(100, 100, 60, 120);

    // Set the elevation angle
    c.addTitle("Elevation = " & angle, "Arial Italic", 15);
    c.setViewAngle(angle);

    // Set the pyramid data
    c.setData(data);

    // Set the layer colors to the given colors
    c.setColors2(cd.DataColor, colors);

    // Leave 1% gaps between layers
    c.setLayerGap(0.01);

    // Output the chart
    return c.makeSession(GetPageContext(), "chart" & img);
}

chart0URL = createChart(0);
chart1URL = createChart(1);
chart2URL = createChart(2);
chart3URL = createChart(3);
chart4URL = createChart(4);
chart5URL = createChart(5);
chart6URL = createChart(6);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Pyramid Elevation
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0URL#" />
<img src="getchart.cfm?#chart1URL#" />
<img src="getchart.cfm?#chart2URL#" />
<img src="getchart.cfm?#chart3URL#" />
<img src="getchart.cfm?#chart4URL#" />
<img src="getchart.cfm?#chart5URL#" />
<img src="getchart.cfm?#chart6URL#" />
</cfoutput>
</body>
</html>
