<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the chart
data0 = Array(6, 12.5, 18.2, 15);
angles0 = Array(45, 96, 169, 258);
size0 = Array(41, 105, 12, 20);

data1 = Array(18, 16, 11, 14);
angles1 = Array(30, 210, 240, 310);
size1 = Array(30, 45, 12, 90);

// Create a PolarChart object of size 460 x 460 pixels
c = cd.PolarChart(460, 460);

// Add a title to the chart at the top left corner using 15pts Arial Bold Italic font
c.addTitle2(cd.TopLeft, "<*underline=2*>EM Field Strength", "Arial Bold Italic", 15);

// Set center of plot area at (230, 240) with radius 180 pixels
c.setPlotArea(230, 240, 180);

// Use alternative light grey/dark grey circular background color
c.setPlotAreaBg("0xdddddd", "0xeeeeee");

// Set the grid style to circular grid
c.setGridStyle(False);

// Add a legend box at the top right corner of the chart using 9 pts Arial Bold font
c.addLegend(459, 0, True, "Arial Bold", 9).setAlignment(cd.TopRight);

// Set angular axis as 0 - 360, with a spoke every 30 units
c.angularAxis().setLinearScale(0, 360, 30);

// Set the radial axis label format
c.radialAxis().setLabelFormat("{value} km");

// Add a blue (0x9999ff) line layer to the chart using (data0, angle0)
layer0 = c.addLineLayer(data0, "0x9999ff", "Cold Spot");
layer0.setAngles(angles0);

// Disable the line by setting its width to 0, so only the symbols are visible
layer0.setLineWidth(0);

// Use a circular data point symbol
layer0.setDataSymbol(cd.CircleSymbol, 11);

// Modulate the symbol size by size0 to produce a bubble chart effect
layer0.setSymbolScale(size0);

// Add a red (0xff9999) line layer to the chart using (data1, angle1)
layer1 = c.addLineLayer(data1, "0xff9999", "Hot Spot");
layer1.setAngles(angles1);

// Disable the line by setting its width to 0, so only the symbols are visible
layer1.setLineWidth(0);

// Use a circular data point symbol
layer1.setDataSymbol(cd.CircleSymbol, 11);

// Modulate the symbol size by size1 to produce a bubble chart effect
layer1.setSymbolScale(size1);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{dataSetName} at ({value} km, {angle} deg)<*br*>Strength = {z} Watt'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Polar Bubble Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
