<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the pie chart
data = Array(72, 18, 15, 12);

// The labels for the pie chart
labels = Array("Labor", "Machinery", "Facilities", "Computers");

// The depths for the sectors
depths = Array(30, 20, 10, 10);

// Create a PieChart object of size 360 x 300 pixels, with a light blue (DDDDFF)
// background and a 1 pixel 3D border
c = cd.PieChart(360, 300, "0xddddff", -1, 1);

// Set the center of the pie at (180, 175) and the radius to 100 pixels
c.setPieSize(180, 175, 100);

// Add a title box using 15 pts Times Bold Italic font and blue (AAAAFF) as
// background color
c.addTitle("Project Cost Breakdown", "Times New Roman Bold Italic", 15
    ).setBackground("0xaaaaff");

// Set the pie data and the pie labels
c.setData(data, labels);

// Draw the pie in 3D with variable 3D depths
c.set3D2(depths);

// Set the start angle to 225 degrees may improve layout when the depths of the
// sector are sorted in descending order, because it ensures the tallest sector is at
// the back.
c.setStartAngle(225);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='{label}: US${value}K ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Multi-Depth Pie Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
