<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the bar chart
data0 = Array(100, 125, 245, 147, 67);
data1 = Array(85, 156, 179, 211, 123);
data2 = Array(97, 87, 56, 267, 157);
labels = Array("Mon", "Tue", "Wed", "Thu", "Fri");

// Create a XYChart object of size 400 x 240 pixels
c = cd.XYChart(400, 240);

// Add a title to the chart using 10 pt Arial font
c.addTitle("         Average Weekday Network Load", "", 10);

// Set the plot area at (50, 25) and of size 320 x 180. Use two alternative
// background colors (0xffffc0 and 0xffffe0)
c.setPlotArea(50, 25, 320, 180, "0xffffc0", "0xffffe0");

// Add a legend box at (55, 18) using horizontal layout. Use 8 pt Arial font, with
// transparent background
c.addLegend(55, 18, False, "", 8).setBackground(cd.Transparent);

// Add a title to the y-axis
c.yAxis().setTitle("Throughput (MBytes Per Hour)");

// Reserve 20 pixels at the top of the y-axis for the legend box
c.yAxis().setTopMargin(20);

// Set the x axis labels
c.xAxis().setLabels(labels);

// Add a multi-bar layer with 3 data sets and 3 pixels 3D depth
layer = c.addBarLayer2(cd.Side, 3);
layer.addDataSet(data0, "0xff8080", "Server ##1");
layer.addDataSet(data1, "0x80ff80", "Server ##2");
layer.addDataSet(data2, "0x8080ff", "Server ##3");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{dataSetName} on {xLabel}: {value} MBytes/hour'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Multi-Bar Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
