<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the pie chart
data = Array(28, 45, 5, 1, 12);

// The labels for the pie chart
labels = Array("Excellent", "Good", "Bad", "Very Bad", "Neutral");

// The icons for the sectors
icons = Array("laugh.png", "smile.png", "sad.png", "angry.png", "nocomment.png");

// Create a PieChart object of size 560 x 300 pixels, with a silver background, black
// border, 1 pxiel 3D border effect and rounded corners
c = cd.PieChart(560, 300, cd.silverColor(), "0x000000", 1);
c.setRoundedFrame();

// Set search path to current directory for loading icon images
c.setSearchPath(GetPageContext());

// Set the center of the pie at (280, 150) and the radius to 120 pixels
c.setPieSize(280, 150, 120);

// Add a title box with title written in CDML, on a sky blue (A0C8FF) background with
// glass effect
c.addTitle(
    "<*block,valign=absmiddle*><*img=doc.png*> Customer Survey: <*font=Times New " &
    "Roman Italic,color=000000*>Do you like our <*font,color=dd0000*>Hyper" &
    "<*super*>TM<*/font*> molecules?", "Times New Roman Bold Italic", 15, "0x000080"
    ).setBackground("0xa0c8ff", "0x000000", cd.glassEffect());

// Add a logo to the chart written in CDML as the bottom title aligned to the bottom
// right
c.addTitle2(cd.BottomRight,
    "<*block,valign=absmiddle*><*img=molecule.png*> <*block*><*color=FF*>" &
    "<*font=Times New Roman Bold Italic,size=12*>Molecular Engineering<*br*>" &
    "<*font=Arial,size=10*>Creating better molecules");

// Set the pie data and the pie labels
c.setData(data, labels);

// Set 3D style
c.set3D();

// Use the side label layout method
c.setLabelLayout(cd.SideLayout);

// Set the label background color to transparent
c.setLabelStyle().setBackground(cd.Transparent);

// Add icons to the chart as a custom field
c.addExtraField(icons);

// Configure the sector labels using CDML to include the icon images
c.setLabelFormat("<*block,valign=absmiddle*><*img={field0}*> {label} ({percent|0}%)")
    ;

// Explode the 3rd and 4th sectors as a group (index = 2 and 3)
c.setExplodeGroup(2, 3);

// Set the start angle to 135 degrees may improve layout when there are many small
// sectors at the end of the data array (that is, data sorted in descending order).
// It is because this makes the small sectors position near the horizontal axis,
// where the text label has the least tendency to overlap. For data sorted in
// ascending order, a start angle of 45 degrees can be used instead.
c.setStartAngle(135);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{label}: {value} responses ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Icon Pie Chart (2)
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
