<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The value to display on the meter
value = 85;

// Create an AugularMeter object of size 70 x 90 pixels, using black background with
// a 2 pixel 3D depressed border.
m = cd.AngularMeter(70, 90, 0, 0, -2);

// Set search path to current directory for loading icon images
m.setSearchPath(GetPageContext());

// Use white on black color palette for default text and line colors
m.setColors(cd.whiteOnBlackPalette);

// Set the meter center at (10, 45), with radius 50 pixels, and span from 135 to 45
// degress
m.setMeter(10, 45, 50, 135, 45);

// Set meter scale from 0 - 100, with the specified labels
m.setScale2(0, 100, Array("E", " ", " ", " ", "F"));

// Set the angular arc and major tick width to 2 pixels
m.setLineWidth(2, 2);

// Add a red zone at 0 - 15
m.addZone(0, 15, "0xff3333");

// Add an icon at (25, 35)
m.addText(25, 35, "<*img=gas.gif*>");

// Add a yellow (ffff00) pointer at the specified value
m.addPointer(value, "0xffff00");

// Output the chart
chart1URL = m.makeSession(GetPageContext(), "chart1");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Icon Angular Meter
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" />
</cfoutput>
</body>
</html>
