<!--- The selected year should be in a query parameter called "xLabel" --->
<cfset selectedYear = IIf(IsDefined("URL.xLabel"), "URL.xLabel", "2001")>

<!--- Query data from the selected year and read them into arrays --->
<cfquery name="selectedData" datasource="cdsample">
    SELECT * FROM Revenue WHERE Year(timeStamp) = #selectedYear# Order By timeStamp
</cfquery>
<cfset software = selectedData["Software"].toArray()>
<cfset hardware = selectedData["Hardware"].toArray()>
<cfset services = selectedData["Services"].toArray()>

<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Create a XYChart object of size 600 x 360 pixels
c = cd.XYChart(600, 360);

// Set the plotarea at (60, 50) and of size 480 x 270 pixels. Use a vertical gradient
// color from light blue (eeeeff) to deep blue (0000cc) as background. Set border and
// grid lines to white (ffffff).
c.setPlotArea(60, 50, 480, 270, c.linearGradientColor(60, 50, 60, 270, "0xeeeeff",
    "0x0000cc"), -1, "0xffffff", "0xffffff");

// Add a title to the chart using 15pts Times Bold Italic font
c.addTitle("Global Revenue for Year " & selectedYear, "Times New Roman Bold Italic",
    18);

// Add a legend box at (60, 25) (top of the plotarea) with 9pts Arial Bold font
c.addLegend(60, 25, False, "Arial Bold", 9).setBackground(cd.Transparent);

// Add a line chart layer using the supplied data
layer = c.addLineLayer2();
layer.addDataSet(software, "0xffaa00", "Software").setDataSymbol(cd.CircleShape, 9);
layer.addDataSet(hardware, "0x00ff00", "Hardware").setDataSymbol(cd.DiamondShape, 11)
    ;
layer.addDataSet(services, "0xff0000", "Services").setDataSymbol(cd.Cross2Shape(), 11
    );

// Set the line width to 3 pixels
layer.setLineWidth(3);

// Set the x axis labels. In this example, the labels must be Jan - Dec.
labels = Array("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sept", "Oct",
    "Nov", "Dec");
c.xAxis().setLabels(labels);

// Set y-axis tick density to 30 pixels. ChartDirector auto-scaling will use this as
// the guideline when putting ticks on the y-axis.
c.yAxis().setTickDensity(30);

// Synchronize the left and right y-axes
c.syncYAxis();

// Set the y axes titles with 10pts Arial Bold font
c.yAxis().setTitle("USD (Millions)", "Arial Bold", 10);
c.yAxis2().setTitle("USD (Millions)", "Arial Bold", 10);

// Set all axes to transparent
c.xAxis().setColors(cd.Transparent);
c.yAxis().setColors(cd.Transparent);
c.yAxis2().setColors(cd.Transparent);

// Set the label styles of all axes to 8pt Arial Bold font
c.xAxis().setLabelStyle("Arial Bold", 8);
c.yAxis().setLabelStyle("Arial Bold", 8);
c.yAxis2().setLabelStyle("Arial Bold", 8);

// Create the image and save it in a temporary location
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Create an image map for the chart
imageMap = c.getHTMLImageMap("xystub.cfm", "",
    "title='{dataSetName} @ {xLabel} = USD {value|0}M'");

</cfscript>

<html>
<cfoutput>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Database Clickable Charts
</div>
<hr style="border:solid 1px ##000080" />
<div style="font-size:10pt; font-family:verdana; width:600px; margin-bottom:20px">
    You have click the bar for the year #selectedYear#.
    Below is the "drill-down" chart showing the monthly details.
<br /><br />
<a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>
    View source code
</a>
</div>

<img src="getchart.cfm?#chart1URL#" border="0" usemap="##map1">
<map name="map1">
#imageMap#
</map>

</body>
</cfoutput>
</html>
