<!--- Read the revenue from 1990 to 2001 and into arrays --->
<cfquery name="selectedData" datasource="cdsample">
    Select
        Sum(Software + Hardware + Services) As annualRevenue,
        Year(TimeStamp) As Year
    From revenue
    Where Year(TimeStamp) >= 1990 And Year(TimeStamp) <= 2001
    Group By Year(TimeStamp) Order By Year(TimeStamp)
</cfquery>
<cfset revenue = selectedData["annualRevenue"].toArray()>
<cfset timestamp = selectedData["Year"].toArray()>

<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// Create a XYChart object of size 600 x 360 pixels
c = cd.XYChart(600, 360);

// Set the plotarea at (60, 40) and of size 480 x 280 pixels. Use a vertical gradient
// color from light blue (eeeeff) to deep blue (0000cc) as background. Set border and
// grid lines to white (ffffff).
c.setPlotArea(60, 40, 480, 280, c.linearGradientColor(60, 40, 60, 280, "0xeeeeff",
    "0x0000cc"), -1, "0xffffff", "0xffffff");

// Add a title to the chart using 18pts Times Bold Italic font
c.addTitle("Annual Revenue for Star Tech", "Times New Roman Bold Italic", 18);

// Add a multi-color bar chart layer using the supplied data
layer = c.addBarLayer3(revenue);

// Use glass lighting effect with light direction from the left
layer.setBorderColor(cd.Transparent, cd.glassEffect(cd.NormalGlare, cd.Left));

// Set the x axis labels
c.xAxis().setLabels(timestamp);

// Set y-axis tick density to 30 pixels. ChartDirector auto-scaling will use this as
// the guideline when putting ticks on the y-axis.
c.yAxis().setTickDensity(30);

// Synchronize the left and right y-axes
c.syncYAxis();

// Set the y axes titles with 10pts Arial Bold font
c.yAxis().setTitle("USD (Millions)", "Arial Bold", 10);
c.yAxis2().setTitle("USD (Millions)", "Arial Bold", 10);

// Set all axes to transparent
c.xAxis().setColors(cd.Transparent);
c.yAxis().setColors(cd.Transparent);
c.yAxis2().setColors(cd.Transparent);

// Set the label styles of all axes to 8pt Arial Bold font
c.xAxis().setLabelStyle("Arial Bold", 8);
c.yAxis().setLabelStyle("Arial Bold", 8);
c.yAxis2().setLabelStyle("Arial Bold", 8);

// Create the image
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Create an image map for the chart
imageMap = c.getHTMLImageMap("dbdemo3a.cfm", "", "title='{xLabel}: US$ {value|0}M'");

</cfscript>
<html>
<cfoutput>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Database Clickable Charts
</div>
<hr style="border:solid 1px ##000080" />
<div style="font-size:10pt; font-family:verdana; width:600px; margin-bottom:20px">
    The example demonstrates creating a clickable chart using data from a database.
    Click on a bar below to "drill down" onto a particular year.
<br /><br />
<a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>
    View source code
</a>
</div>

<img src="getchart.cfm?#chart1URL#" border="0" usemap="##map1">
<map name="map1">
#imageMap#
</map>

</body>
</cfoutput>
</html>
