<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the bar chart
data = Array(85, 156, 179.5, 211, 123);

// The labels for the bar chart
labels = Array("Mon", "Tue", "Wed", "Thu", "Fri");

// Create a XYChart object of size 400 x 240 pixels.
c = cd.XYChart(400, 240);

// Add a title to the chart using 14 pts Times Bold Italic font
c.addTitle("Weekly Server Load", "Times New Roman Bold Italic", 14);

// Set the plotarea at (45, 40) and of 300 x 160 pixels in size. Use alternating
// light grey (f8f8f8) / white (ffffff) background.
c.setPlotArea(45, 40, 300, 160, "0xf8f8f8", "0xffffff");

// Add a multi-color bar chart layer
layer = c.addBarLayer3(data);

// Set layer to 3D with 10 pixels 3D depth
layer.set3D(10);

// Set bar shape to circular (cylinder)
layer.setBarShape(cd.CircleShape);

// Set the labels on the x axis.
c.xAxis().setLabels(labels);

// Add a title to the y axis
c.yAxis().setTitle("MBytes");

// Add a title to the x axis
c.xAxis().setTitle("Work Week 25");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='{xLabel}: {value} MBytes'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Cylinder Bar Shape
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
