<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var dataX = 0;
    var dataY = 0;
    var dataZ = 0;
    var yIndex = 0;
    var y = 0;
    var xIndex = 0;
    var x = 0;
    var c = 0;
    var layer = 0;

    // The x and y coordinates of the grid
    dataX = Array(-4, -3, -2, -1, 0, 1, 2, 3, 4);
    dataY = Array(-4, -3, -2, -1, 0, 1, 2, 3, 4);

    // The values at the grid points. In this example, we will compute the values
    // using the formula z = Sin(x * pi / 3) * Sin(y * pi / 3).
    dataZ = ArrayNew(1);
    for (yIndex = 0; yIndex LT ArrayLen(dataY); yIndex = yIndex + 1) {
        y = dataY[yIndex + 1];
        for (xIndex = 0; xIndex LT ArrayLen(dataX); xIndex = xIndex + 1) {
            x = dataX[xIndex + 1];
            dataZ[yIndex * ArrayLen(dataX) + xIndex + 1] = Sin(x * 3.1416 / 3) * Sin(
                y * 3.1416 / 3);
        }
    }

    // Create a XYChart object of size 360 x 360 pixels
    c = cd.XYChart(360, 360);

    // Set the plotarea at (30, 25) and of size 300 x 300 pixels. Use
    // semi-transparent black (c0000000) for both horizontal and vertical grid lines
    c.setPlotArea(30, 25, 300, 300, -1, -1, -1, "0xc0000000", -1);

    // Add a contour layer using the given data
    layer = c.addContourLayer(dataX, dataY, dataZ);

    // Set the x-axis and y-axis scale
    c.xAxis().setLinearScale(-4, 4, 1);
    c.yAxis().setLinearScale(-4, 4, 1);

    if (img EQ "0") {
        // Discrete coloring, spline surface interpolation
        c.addTitle("Spline Surface - Discrete Coloring", "Arial Bold Italic", 12);
    } else if (img EQ "1") {
        // Discrete coloring, linear surface interpolation
        c.addTitle("Linear Surface - Discrete Coloring", "Arial Bold Italic", 12);
        layer.setSmoothInterpolation(False);
    } else if (img EQ "2") {
        // Smooth coloring, spline surface interpolation
        c.addTitle("Spline Surface - Continuous Coloring", "Arial Bold Italic", 12);
        layer.setContourColor(cd.Transparent);
        layer.colorAxis().setColorGradient(True);
    } else {
        // Discrete coloring, linear surface interpolation
        c.addTitle("Linear Surface - Continuous Coloring", "Arial Bold Italic", 12);
        layer.setSmoothInterpolation(False);
        layer.setContourColor(cd.Transparent);
        layer.colorAxis().setColorGradient(True);
    }

    // Output the chart
    return c.makeSession(GetPageContext(), "chart" & img, cd.JPG);
}

chart0URL = createChart(0);
chart1URL = createChart(1);
chart2URL = createChart(2);
chart3URL = createChart(3);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Contour Interpolation
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0URL#" />
<img src="getchart.cfm?#chart1URL#" />
<img src="getchart.cfm?#chart2URL#" />
<img src="getchart.cfm?#chart3URL#" />
</cfoutput>
</body>
</html>
