<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The x and y coordinates of the grid
dataX = Array(-10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10);
dataY = Array(-10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10);

// The values at the grid points. In this example, we will compute the values using
// the formula z = x * sin(y) + y * sin(x).
dataZ = ArrayNew(1);
for (yIndex = 0; yIndex LT ArrayLen(dataY); yIndex = yIndex + 1) {
    y = dataY[yIndex + 1];
    for (xIndex = 0; xIndex LT ArrayLen(dataX); xIndex = xIndex + 1) {
        x = dataX[xIndex + 1];
        dataZ[yIndex * ArrayLen(dataX) + xIndex + 1] = x * Sin(y) + y * Sin(x);
    }
}

// Create a XYChart object of size 600 x 500 pixels
c = cd.XYChart(600, 500);

// Add a title to the chart using 15 points Arial Bold Italic font
c.addTitle("z = x * sin(y) + y * sin(x)      ", "Arial Bold Italic", 15);

// Set the plotarea at (75, 40) and of size 400 x 400 pixels. Use semi-transparent
// black (80000000) dotted lines for both horizontal and vertical grid lines
c.setPlotArea(75, 40, 400, 400, -1, -1, -1, c.dashLineColor("0x80000000", cd.DotLine
    ), -1);

// Set x-axis and y-axis title using 12 points Arial Bold Italic font
c.xAxis().setTitle("X-Axis Title Place Holder", "Arial Bold Italic", 12);
c.yAxis().setTitle("Y-Axis Title Place Holder", "Arial Bold Italic", 12);

// Set x-axis and y-axis labels to use Arial Bold font
c.xAxis().setLabelStyle("Arial Bold");
c.yAxis().setLabelStyle("Arial Bold");

// When auto-scaling, use tick spacing of 40 pixels as a guideline
c.yAxis().setTickDensity(40);
c.xAxis().setTickDensity(40);

// Add a contour layer using the given data
layer = c.addContourLayer(dataX, dataY, dataZ);

// Move the grid lines in front of the contour layer
c.getPlotArea().moveGridBefore(layer);

// Add a color axis (the legend) in which the top left corner is anchored at (505,
// 40). Set the length to 400 pixels and the labels on the right side.
cAxis = layer.setColorAxis(505, 40, cd.TopLeft, 400, cd.Right);

// Add a title to the color axis using 12 points Arial Bold Italic font
cAxis.setTitle("Color Legend Title Place Holder", "Arial Bold Italic", 12);

// Set color axis labels to use Arial Bold font
cAxis.setLabelStyle("Arial Bold");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Contour Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" />
</cfoutput>
</body>
</html>
