<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The XY data of the first data series
dataX = Array(50, 55, 37, 24, 42, 49, 63, 72, 83, 59);
dataY = Array(3.6, 2.8, 2.5, 2.3, 3.8, 3.0, 3.8, 5.0, 6.0, 3.3);

// Create a XYChart object of size 450 x 420 pixels
c = cd.XYChart(450, 420);

// Set the plotarea at (55, 65) and of size 350 x 300 pixels, with white background
// and a light grey border (0xc0c0c0). Turn on both horizontal and vertical grid
// lines with light grey color (0xc0c0c0)
c.setPlotArea(55, 65, 350, 300, "0xffffff", -1, "0xc0c0c0", "0xc0c0c0", -1);

// Add a title to the chart using 18 point Times Bold Itatic font.
c.addTitle("Server Performance", "Times New Roman Bold Italic", 18);

// Add titles to the axes using 12 pts Arial Bold Italic font
c.yAxis().setTitle("Response Time (sec)", "Arial Bold Italic", 12);
c.xAxis().setTitle("Server Load (TPS)", "Arial Bold Italic", 12);

// Set the axes line width to 3 pixels
c.yAxis().setWidth(3);
c.xAxis().setWidth(3);

// Add a scatter layer using (dataX, dataY)
scatterLayer = c.addScatterLayer(dataX, dataY, "", cd.DiamondSymbol, 11, "0x008000");

// tool tip for scatter layer
scatterLayer.setHTMLImageMap("", "", "title='Response time at {x} TPS: {value} sec'")
    ;

// Add a trend line layer for (dataX, dataY)
trendLayer = c.addTrendLayer2(dataX, dataY, "0x008000");

// Set the line width to 3 pixels
trendLayer.setLineWidth(3);

// Add a 95% confidence band for the line
trendLayer.addConfidenceBand(0.95, "0x806666ff");

// Add a 95% confidence band (prediction band) for the points
trendLayer.addPredictionBand(0.95, "0x8066ff66");

// tool tip for trend layer
trendLayer.setHTMLImageMap("", "",
    "title='Slope = {slope|4} sec/TPS; Intercept = {intercept|4} sec'");

// Add a legend box at (50, 30) (top of the chart) with horizontal layout. Use 10 pts
// Arial Bold Italic font. Set the background and border color to Transparent.
legendBox = c.addLegend(50, 30, False, "Arial Bold Italic", 10);
legendBox.setBackground(cd.Transparent);

// Add entries to the legend box
legendBox.addKey("95% Line Confidence", "0x806666ff");
legendBox.addKey("95% Point Confidence", "0x8066ff66");

// Display the trend line parameters as a text table formatted using CDML
textbox = c.addText(56, 65,
    "<*block*>Slope<*br*>Intercept<*br*>Correlation<*br*>Std Error<*/*>   <*block*>"
     & NumberFormat(trendLayer.getSlope(), ".9999") & " sec/tps<*br*>" &
    NumberFormat(trendLayer.getIntercept(), ".9999") & " sec<*br*>" & NumberFormat(
    trendLayer.getCorrelation(), ".9999") & "<*br*>" & NumberFormat(
    trendLayer.getStdError(), ".9999") & " sec<*/*>", "Arial Bold", 8);

// Set the background of the text box to light grey, with a black border, and 1 pixel
// 3D border
textbox.setBackground("0xc0c0c0", 0, 1);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// include tool tip for the chart
imageMap1 = c.getHTMLImageMap("");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Confidence Band
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
