<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var data = 0;
    var labels = 0;
    var colors = 0;
    var c = 0;
    var ret = 0;

    // The data for the pie chart
    data = Array(25, 18, 15, 12, 8, 30, 35);

    // The labels for the pie chart
    labels = Array("Labor", "Licenses", "Taxes", "Legal", "Insurance", "Facilities",
        "Production");

    // Colors of the sectors if custom coloring is used
    colors = Array("0xb8bc9c", "0xecf0b9", "0x999966", "0x333366", "0xc3c3e6",
        "0x594330", "0xa0bdc4");

    // Create a PieChart object of size 280 x 240 pixels
    c = cd.PieChart(280, 240);

    // Set search path to current directory for loading icon images
    c.setSearchPath(GetPageContext());

    // Set the center of the pie at (140, 120) and the radius to 80 pixels
    c.setPieSize(140, 120, 80);

    // Draw the pie in 3D
    c.set3D();

    // Set the coloring schema
    if (img EQ "0") {
        c.addTitle("Custom Colors");
        // set the LineColor to light gray
        c.setColor(cd.LineColor, "0xc0c0c0");
        // use given color array as the data colors (sector colors)
        c.setColors2(cd.DataColor, colors);
    } else if (img EQ "1") {
        c.addTitle("Dark Background Colors");
        // use the standard white on black palette
        c.setColors(cd.whiteOnBlackPalette);
    } else if (img EQ "2") {
        c.addTitle("Wallpaper As Background");
        c.setWallpaper("bg.png");
    } else {
        c.addTitle("Transparent Colors");
        c.setWallpaper("bg.png");
        // use semi-transparent colors to allow the background to be seen
        c.setColors(cd.transparentPalette);
    }

    // Set the pie data and the pie labels
    c.setData(data, labels);

    // Explode the 1st sector (index = 0)
    c.setExplode(0);

    // Output the chart
    ret = StructNew();
    ret.imageURL = c.makeSession(GetPageContext(), "chart" & img, cd.GIF);

    // Include tool tip for the chart
    ret.imageMap = c.getHTMLImageMap("", "",
        "title='{label}: US${value}K ({percent}%)'");

    return ret;
}

chart0 = createChart(0);
chart1 = createChart(1);
chart2 = createChart(2);
chart3 = createChart(3);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Coloring and Wallpaper
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0.imageURL#" usemap="##map0" border="0" />
<map name="map0">#chart0.imageMap#</map>
<img src="getchart.cfm?#chart1.imageURL#" usemap="##map1" border="0" />
<map name="map1">#chart1.imageMap#</map>
<img src="getchart.cfm?#chart2.imageURL#" usemap="##map2" border="0" />
<map name="map2">#chart2.imageMap#</map>
<img src="getchart.cfm?#chart3.imageURL#" usemap="##map3" border="0" />
<map name="map3">#chart3.imageMap#</map>
</cfoutput>
</body>
</html>
