<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Get the selected year and month
selectedYear = Int(URL.year);
selectedMonth = Int(URL.x) + 1;

//
// In real life, the data may come from a database based on selectedYear. In this
// example, we just use a random number generator.
//
seed = (selectedYear - 1992) * (100 + 3 * selectedMonth);
rantable = cd.RanTable(seed, 1, 4);
rantable.setCol(0, seed * 0.003, seed * 0.017);

data = rantable.getCol(0);

// The labels for the pie chart
labels = Array("Services", "Hardware", "Software", "Others");

// Create a PieChart object of size 600 x 240 pixels
c = cd.PieChart(600, 280);

// Set the center of the pie at (300, 140) and the radius to 120 pixels
c.setPieSize(300, 140, 120);

// Add a title to the pie chart using 18 pts Times Bold Italic font
c.addTitle("Revenue Breakdown for " & selectedMonth & "/" & selectedYear,
    "Times New Roman Bold Italic", 18);

// Draw the pie in 3D with 20 pixels 3D depth
c.set3D(20);

// Set label format to display sector label, value and percentage in two lines
c.setLabelFormat("{label}<*br*>${value|2}M ({percent}%)");

// Set label style to 10 pts Arial Bold Italic font. Set background color to the same
// as the sector color, with reduced-glare glass effect and rounded corners.
t = c.setLabelStyle("Arial Bold Italic", 10);
t.setBackground(cd.SameAsMainColor, cd.Transparent, cd.glassEffect(cd.ReducedGlare));
t.setRoundedCorners();

// Use side label layout method
c.setLabelLayout(cd.SideLayout);

// Set the pie data and the pie labels
c.setData(data, labels);

// Create the image and save it in a temporary location
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Create an image map for the chart
imageMap = c.getHTMLImageMap("piestub.cfm", "", "title='{label}:US$ {value|2}M'");

</cfscript>
<html>
<cfoutput>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Simple Clickable Pie Chart
</div>
<hr style="border:solid 1px ##000080" />
<div style="font-size:10pt; font-family:verdana; margin-bottom:20">
    <a href="viewsource.cfm?file=#CGI.SCRIPT_NAME#">View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" border="0" usemap="##map1">
<map name="map1">
#imageMap#
</map>
</body>
</cfoutput>
</html>
