<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var data = 0;
    var labels = 0;
    var colors = 0;
    var c = 0;
    var ret = 0;

    // The data for the pie chart
    data = Array(42, 18, 8);

    // The labels for the pie chart
    labels = Array("Agree", "Disagree", "Not Sure");

    // The colors to use for the sectors
    colors = Array("0x66ff66", "0xff6666", "0xffff00");

    // Create a PieChart object of size 300 x 300 pixels. Set the background to a
    // gradient color from blue (aaccff) to sky blue (ffffff), with a grey (888888)
    // border. Use rounded corners and soft drop shadow.
    c = cd.PieChart(300, 300);
    c.setBackground(c.linearGradientColor(0, 0, 0, c.getHeight() / 2, "0xaaccff",
        "0xffffff"), "0x888888");
    c.setRoundedFrame();
    c.setDropShadow();

    if (img EQ "0") {
    //============================================================
    //    Draw a pie chart where the label is on top of the pie
    //============================================================

        // Set the center of the pie at (150, 150) and the radius to 120 pixels
        c.setPieSize(150, 150, 120);

        // Set the label position to -40 pixels from the perimeter of the pie (-ve
        // means label is inside the pie)
        c.setLabelPos(-40);

    } else {
    //============================================================
    //    Draw a pie chart where the label is outside the pie
    //============================================================

        // Set the center of the pie at (150, 150) and the radius to 80 pixels
        c.setPieSize(150, 150, 80);

        // Set the sector label position to be 20 pixels from the pie. Use a join
        // line to connect the labels to the sectors.
        c.setLabelPos(20, cd.LineColor);

    }

    // Set the pie data and the pie labels
    c.setData(data, labels);

    // Set the sector colors
    c.setColors2(cd.DataColor, colors);

    // Use local gradient shading, with a 1 pixel semi-transparent black (bb000000)
    // border
    c.setSectorStyle(cd.LocalGradientShading, "0xbb000000", 1);

    // Output the chart
    ret = StructNew();
    ret.imageURL = c.makeSession(GetPageContext(), "chart" & img);

    // Include tool tip for the chart
    ret.imageMap = c.getHTMLImageMap("", "",
        "title='{label}: {value} responses ({percent}%)'");

    return ret;
}

chart0 = createChart(0);
chart1 = createChart(1);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Circular Label Layout
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0.imageURL#" usemap="##map0" border="0" />
<map name="map0">#chart0.imageMap#</map>
<img src="getchart.cfm?#chart1.imageURL#" usemap="##map1" border="0" />
<map name="map1">#chart1.imageMap#</map>
</cfoutput>
</body>
</html>
