<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The XY points for the bubble chart. The bubble chart has independent bubble size
// on the X and Y direction.
dataX0 = Array(1000, 1500, 1700);
dataY0 = Array(25, 20, 65);
dataZX0 = Array(500, 200, 600);
dataZY0 = Array(15, 30, 20);

dataX1 = Array(500, 1000, 1300);
dataY1 = Array(35, 50, 75);
dataZX1 = Array(800, 300, 500);
dataZY1 = Array(8, 27, 25);

dataX2 = Array(150, 300);
dataY2 = Array(20, 60);
dataZX2 = Array(160, 400);
dataZY2 = Array(30, 20);

// Create a XYChart object of size 450 x 420 pixels
c = cd.XYChart(450, 420);

// Set the plotarea at (55, 65) and of size 350 x 300 pixels, with a light grey
// border (0xc0c0c0). Turn on both horizontal and vertical grid lines with light grey
// color (0xc0c0c0)
c.setPlotArea(55, 65, 350, 300, -1, -1, "0xc0c0c0", "0xc0c0c0", -1);

// Add a legend box at (50, 30) (top of the chart) with horizontal layout. Use 12 pts
// Times Bold Italic font. Set the background and border color to Transparent.
c.addLegend(50, 30, False, "Times New Roman Bold Italic", 12).setBackground(
    cd.Transparent);

// Add a title to the chart using 18 pts Times Bold Itatic font.
c.addTitle("Plasma Battery Comparison", "Times New Roman Bold Italic", 18);

// Add titles to the axes using 12 pts Arial Bold Italic font
c.yAxis().setTitle("Operating Current", "Arial Bold Italic", 12);
c.xAxis().setTitle("Operating Voltage", "Arial Bold Italic", 12);

// Set the axes line width to 3 pixels
c.xAxis().setWidth(3);
c.yAxis().setWidth(3);

// Add (dataX0, dataY0) as a standard scatter layer, and also as a "bubble" scatter
// layer, using circles as symbols. The "bubble" scatter layer has symbol size
// modulated by (dataZX0, dataZY0) using the scale on the x and y axes.
c.addScatterLayer(dataX0, dataY0, "Vendor A", cd.CircleSymbol, 9, "0xff3333",
    "0xff3333");
c.addScatterLayer(dataX0, dataY0, "", cd.CircleSymbol, 9, "0x80ff3333", "0x80ff3333"
    ).setSymbolScale(dataZX0, cd.XAxisScale, dataZY0, cd.YAxisScale);

// Add (dataX1, dataY1) as a standard scatter layer, and also as a "bubble" scatter
// layer, using squares as symbols. The "bubble" scatter layer has symbol size
// modulated by (dataZX1, dataZY1) using the scale on the x and y axes.
c.addScatterLayer(dataX1, dataY1, "Vendor B", cd.SquareSymbol, 7, "0x3333ff",
    "0x3333ff");
c.addScatterLayer(dataX1, dataY1, "", cd.SquareSymbol, 9, "0x803333ff", "0x803333ff"
    ).setSymbolScale(dataZX1, cd.XAxisScale, dataZY1, cd.YAxisScale);

// Add (dataX2, dataY2) as a standard scatter layer, and also as a "bubble" scatter
// layer, using diamonds as symbols. The "bubble" scatter layer has symbol size
// modulated by (dataZX2, dataZY2) using the scale on the x and y axes.
c.addScatterLayer(dataX2, dataY2, "Vendor C", cd.DiamondSymbol, 9, "0x00ff00",
    "0x00ff00");
c.addScatterLayer(dataX2, dataY2, "", cd.DiamondSymbol, 9, "0x8033ff33", "0x8033ff33"
    ).setSymbolScale(dataZX2, cd.XAxisScale, dataZY2, cd.YAxisScale);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='Voltage = {x} +/- {={zx}/2} V, Current = {value} +/- {={zy}/2} A'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Bubble XY Scaling
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
