<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Sample data for the Box-Whisker chart. Represents the minimum, 1st quartile,
// medium, 3rd quartile and maximum values of some quantities
Q0Data = Array(40, 45, 40, 30, 20, 50, 25, 44);
Q1Data = Array(55, 60, 50, 40, 38, 60, 51, 60);
Q2Data = Array(62, 70, 60, 50, 48, 70, 62, 70);
Q3Data = Array(70, 80, 65, 60, 53, 78, 69, 76);
Q4Data = Array(80, 90, 75, 70, 60, 85, 80, 84);

// The labels for the chart
labels = Array("Group A", "Group B", "Group C", "Group D", "Group E", "Group F",
    "Group G", "Group H");

// Create a XYChart object of size 550 x 250 pixels
c = cd.XYChart(550, 250);

// Set the plotarea at (50, 25) and of size 450 x 200 pixels. Enable both horizontal
// and vertical grids by setting their colors to grey (0xc0c0c0)
c.setPlotArea(50, 25, 450, 200).setGridColor("0xc0c0c0", "0xc0c0c0");

// Add a title to the chart
c.addTitle("Computer Vision Test Scores");

// Set the labels on the x axis and the font to Arial Bold
c.xAxis().setLabels(labels).setFontStyle("Arial Bold");

// Set the font for the y axis labels to Arial Bold
c.yAxis().setLabelStyle("Arial Bold");

// Add a Box Whisker layer using light blue 0x9999ff as the fill color and blue
// (0xcc) as the line color. Set the line width to 2 pixels
c.addBoxWhiskerLayer(Q3Data, Q1Data, Q4Data, Q0Data, Q2Data, "0x9999ff", "0x0000cc"
    ).setLineWidth(2);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{xLabel}: min/med/max = {min}/{med}/{max}<*br*>Inter-quartile range: " &
    "{bottom} to {top}'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Box-Whisker Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
