<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var data = 0;
    var labels = 0;
    var c = 0;
    var ret = 0;

    // The data for the chart
    data = Array(5.5, 3.5, -3.7, 1.7, -1.4, 3.3);
    labels = Array("Jan", "Feb", "Mar", "Apr", "May", "Jun");

    // Create a XYChart object of size 200 x 190 pixels
    c = cd.XYChart(200, 190);

    // Set the plot area at (30, 20) and of size 140 x 140 pixels
    c.setPlotArea(30, 20, 140, 140);

    // Configure the axis as according to the input parameter
    if (img EQ "0") {
        c.addTitle("No Axis Extension", "Arial", 8);
    } else if (img EQ "1") {
        c.addTitle("Top/Bottom Extensions = 0/0", "Arial", 8);
        // Reserve 20% margin at top of plot area when auto-scaling
        c.yAxis().setAutoScale(0, 0);
    } else if (img EQ "2") {
        c.addTitle("Top/Bottom Extensions = 0.2/0.2", "Arial", 8);
        // Reserve 20% margin at top and bottom of plot area when auto-scaling
        c.yAxis().setAutoScale(0.2, 0.2);
    } else if (img EQ "3") {
        c.addTitle("Axis Top Margin = 15", "Arial", 8);
        // Reserve 15 pixels at top of plot area
        c.yAxis().setMargin(15);
    } else {
        c.addTitle("Manual Scale -5 to 10", "Arial", 8);
        // Set the y axis to scale from -5 to 10, with ticks every 5 units
        c.yAxis().setLinearScale(-5, 10, 5);
    }

    // Set the labels on the x axis
    c.xAxis().setLabels(labels);

    // Add a color bar layer using the given data. Use a 1 pixel 3D border for the
    // bars.
    c.addBarLayer3(data).setBorderColor(-1, 1);

    // Output the chart
    ret = StructNew();
    ret.imageURL = c.makeSession(GetPageContext(), "chart" & img);

    // Include tool tip for the chart
    ret.imageMap = c.getHTMLImageMap("", "", "title='ROI for {xLabel}: {value}%'");

    return ret;
}

chart0 = createChart(0);
chart1 = createChart(1);
chart2 = createChart(2);
chart3 = createChart(3);
chart4 = createChart(4);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Y-Axis Scaling
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0.imageURL#" usemap="##map0" border="0" />
<map name="map0">#chart0.imageMap#</map>
<img src="getchart.cfm?#chart1.imageURL#" usemap="##map1" border="0" />
<map name="map1">#chart1.imageMap#</map>
<img src="getchart.cfm?#chart2.imageURL#" usemap="##map2" border="0" />
<map name="map2">#chart2.imageMap#</map>
<img src="getchart.cfm?#chart3.imageURL#" usemap="##map3" border="0" />
<map name="map3">#chart3.imageMap#</map>
<img src="getchart.cfm?#chart4.imageURL#" usemap="##map4" border="0" />
<map name="map4">#chart4.imageMap#</map>
</cfoutput>
</body>
</html>
