<?php
/**
 * Handle de requisiÃÂ§ÃÂµes pelo gateway utilizando XML ou JSON
 *
 * @author Lukas Jacomin
 */ 
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
ini_set("error_reporting", E_ALL ^ E_NOTICE ^ E_WARNING);

require_once "Request.class.php";
require_once "Utils.class.php";
require_once "JWT.class.php";
require_once($_SERVER['DOCUMENT_ROOT'].'/config/lock.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/_class/funcoes/data_sources.php');

$ambiente = "PRODUCAO";
$defaultUser = "publico";
$defaultPassword = "kmm2006";

if(preg_match("/s([0-9]{2})b([0-9]{2}).kmm.com.br/i", $_SERVER['HTTP_HOST'], $matches)) {
   $slot = "S{$matches[1]}B{$matches[2]}";

   $dsns[$slot] = array(
						"DBTYPE" => "oracle",
						"TNS" => "(DESCRIPTION =
                                 (ADDRESS_LIST =
                                    (ADDRESS = (PROTOCOL = TCP)(HOST = s{$matches[1]}.kmm.com.br)(PORT = 1521))
                                 )
                                 (CONNECT_DATA =
                                    (SID = $slot)
                                 )
                              )",
						  "USERNAME" => "",
						  "PASSWORD" => ""
   );
   $_SESSION['dsn'] = $slot;
   $ambiente = $slot;
}

$tns = $dsns[$_SESSION['dsn']]['TNS'];

$chaveSSL = "]]as+01";
$cryptMethod = "AES256";

$request = new Request(); // Inicializa as variÃÂ¡veis ÃÂºteis

// NecessÃÂ¡rio para CORS
if($_SERVER["REQUEST_METHOD"] == "OPTIONS") {
   $request->responseHeaders();
   die();
}

try {
   if(!in_array($cryptMethod, openssl_get_cipher_methods(true))) {
      //Compatibilidade com o PHP 7+
	  if(!in_array(strtolower($cryptMethod), openssl_get_cipher_methods(true))) {
	     throw new Exception("MÃÂ©todo 'AES256' nÃÂ£o encontrado.", 503);
	  }
   }
   
   $response = array(
      "success" => true,
      "code" => 200
   );

   $request->handle(); // Handle aqui pois gera exception
   
   if(!is_array($request->parameters)) {
      $request->parameters = array();
   }
   
   $username = $request->parameters["username"];
   $password = $request->parameters["password"];
   $codGestao = $request->parameters["cod_gestao"];
   $filiais = $request->parameters["filiais"];
   $operation = $request->operation;
   $module = $request->module;
   $paramsXML = Utils::arrayToXml($request->parameters, "params");
   
   if ($request->header("Authorization")) {
      $token = str_replace("Bearer ", "", $request->header("Authorization"));
   } else {
      $token = str_replace("Bearer ", "", $request->header("authorization"));
   }

   if(!Utils::hasValue($module)) {
      throw new Exception("Móddulo não informado.", 405);
   }
   if(!Utils::hasValue($operation)) {
      throw new Exception("Operation não informada.", 405);
   }

   $tokenData = array();
   if(Utils::hasValue($token)) {
      $aux = explode(".", $token);
      $tokenData = json_decode(base64_decode($aux[0]), true);
      $tokenData = $tokenData["data"];
      $username = $tokenData["username"];
      $password = openssl_decrypt($tokenData["password"], $cryptMethod, $chaveSSL);
      $codGestao = $tokenData["cod_gestao"];
      $filiais = $tokenData["filiais"];
   }
   
   // Modulo LOGON
   // Modulo LOGON sem cod_gestao retorna as gestÃÂµes com as filiais
   // Modulo LOGON com cod_gestao e sem filiais, loga em todas as filiais
   // Modulo LOGON com cod_gestao e com filiais, loga nas filiais selecionadas
   if($module == "LOGON" && ($operation == "LOGON" || $operation == "GETGESTOES" || $operation == "LISTGESTOES" || $operation == "TESTCONNECTION" || $operation == "CONNECTDATA" || $operation == "LOGON_EMAIL" ||  $operation == "GETCFCREDENTIALS")) {
      if ($operation == "TESTCONNECTION") {
         die(json_encode(array("status" => "OK")));
      }
      if ($operation == "CONNECTDATA") {
         include($_SERVER['DOCUMENT_ROOT'].'/config/connectdata.php');
         if ($request->header("verify") && $request->header("verify") == "]]as+02") {
            die(json_encode(array(
                               "success"       => true,
			       "cod_aplicacao" => $_CONNECTDATA['cod_aplicacao'],
                               "tns"           => $_CONNECTDATA['tns'],
                               "authtype"      => $_CONNECTDATA['authtype'],
                               "authdata"      => $_CONNECTDATA['authdata']
                            )));
         } else {
            throw new Exception("Acesso nÃo autorizado", 403);
         }
      }
      //Desenvolvido inicialmente para a KMM, para fazer logon com usuÃÂ¡rio e senha do suporte, evitando deixar usuario e senha na aplicaÃÂ§ÃÂ£o
      //por este motivo tem a gestÃÂ£o fixa ali (9)...se um dia precisa adaptar, faremos de uma forma genÃÂ©rica
      if($operation == "LOGON_EMAIL") {
         $conexao = @oci_connect($defaultUser, $defaultPassword, $tns, 'WE8ISO8859P15');
         if($conexao) {
            $stmt = oci_parse($conexao, "SET ROLE KSS_CORPORATIVO IDENTIFIED BY \"()#3F20L13RJ@\"");
            if (!@oci_execute($stmt, OCI_DEFAULT)) {
               throw new Exception(oci_error(), 403);
            }

            $query = "insert into kss.pessoa_usuario_acesso_cur
                         (cod_pessoa, usuario)
                      select cod_pessoa, 'x'
                        from kss.pessoa_unidade_negocio
                       where cod_gestao = (select min(g.cod_gestao)
                                             from kss.pessoa_aplicacao_gestao g
                                            inner join kss.pessoa_unidade_negocio u
                                               on u.cod_gestao = g.cod_gestao) ";
            $stmt = oci_parse($conexao, $query);
            
            if (!oci_execute($stmt, OCI_COMMIT_ON_SUCCESS)) {
               $err = oci_error($stmt);
               throw new Exception(utf8_encode($err["message"]), 500);            
            } else {
               $query = 'select us.usuario
                           from kmm.v$usuario_suporte us
                          where lower(us.email) = lower(:email)
                            and us.data_inativacao is null';

               $stmt = oci_parse($conexao, $query);
               oci_bind_by_name($stmt, ':email', $username, 4000); //necessÃÂ¡rio enviar o e-mail no parametro username

               if (!oci_execute($stmt, OCI_DEFAULT)) {
                  $err = oci_error($stmt);
                  throw new Exception(utf8_encode($err["message"]), 500);            
               } else {
                  $row = oci_fetch_array($stmt, OCI_ASSOC+OCI_RETURN_NULLS);
                  $username = $row["USUARIO"];
                  $operation = "LOGON";
                  $codGestao = 9;
               }
            }
         }
      }
      if($operation == "GETCFCREDENTIALS") {
         $operation = "LOGON";
         $username = "consultacf";
         $password = "Kmm2021";
         $codGestao = 90481;
      }
      
      // Se nÃÂ£o tiver selecionado gestÃÂ£o, retornar uma lista de gestÃÂµes
      if(!Utils::hasValue($codGestao) && !Utils::hasValue($filiais)) {
         $operation = "GETGESTOES";
      }
   } else {
      $tokenData = array();
      if(Utils::hasValue($token)) {
         $tokenData = JWT::validate($token); // Gera exception
      }
   }

   $conexao = @oci_connect($username, $password, $tns, 'WE8ISO8859P15');
   //$conexao = @oci_connect($username, $password, $tns, 'AL32UTF8');
   if($conexao === FALSE) {
      $err = oci_error();
      switch ($err["code"]) {
            case '1017':
                  throw new Exception("Problema com a conexão. Verifique o usuário/senha digitado.", 403);# code...
            break;
            case 28000:
			throw new Exception("UsuÃ¡rio bloqueado. Consulte o administrador do site.", 403);
		break;
		case 28001:
			throw new Exception("Senha expirada. Acesse o corporativo/web para modificá-la.", 403);
            break;

            default:
                  throw new Exception("Falha ao realizar conexÃ£o com banco de dados.", 403);
      }
   } else {
      $stmt = oci_parse($conexao, "SET ROLE KSS_CORPORATIVO IDENTIFIED BY \"()#3F20L13RJ@\"");
      if (!@oci_execute($stmt, OCI_DEFAULT)) {
         throw new Exception(oci_error(), 403);
      }

      // Se module e operation == "LOGON", retorna o token
      if($module === "LOGON" && $operation === "LOGON") {
         $tokenData = array(
            "username" => $username,
            "password" => openssl_encrypt($password, $cryptMethod, $chaveSSL),
            "cod_gestao" => $codGestao,
            "filiais" => $filiais
         );
         // 30 dias
         if ($request->header("Token-Time-Hours")) {
            $tokenTimeHours = $request->header("Token-Time-Hours");
         } else { 
            $tokenTimeHours = $request->header("token-time-hours");
         }
         if(!Utils::hasValue($tokenTimeHours) || $tokenTimeHours === 0) {
            $tokenTimeHours = 6 * 30 * 24; // 180 dias
         }
         $tempo = $tokenTimeHours * 60 * 60;
         $response["result"]["token"] = JWT::generateToken($tokenData, $tempo);
	      $response["result"]["ambiente"] = $ambiente;
      } else {
         $query = "begin
                  kss.pkg_remote.prc_gateway(p_cod_gestao   => :p_cod_gestao,
                                             p_filiais      => :p_filiais,
                                             p_module       => :p_module,
                                             p_operation    => :p_operation,
                                             p_parameters   => :p_parameters,
                                             p_result       => :p_result
                                             );
               end;";
         $stmt = oci_parse($conexao, $query);
         oci_bind_by_name($stmt, ':p_cod_gestao', $codGestao, 4000);
         oci_bind_by_name($stmt, ':p_filiais', $filiais, 4000);
         oci_bind_by_name($stmt, ':p_module', $module, 4000);
         oci_bind_by_name($stmt, ':p_operation', $operation, 4000);
         $parametersXMLGateway = oci_new_descriptor($conexao, OCI_D_LOB);
         $result = oci_new_descriptor($conexao, OCI_D_LOB);
         $parametersXMLGateway->writeTemporary($paramsXML, OCI_TEMP_CLOB);
         oci_bind_by_name($stmt, ':p_parameters', $parametersXMLGateway, -1, OCI_B_CLOB);
         oci_bind_by_name($stmt, ':p_result', $result, -1, OCI_B_CLOB);
         
         if (!oci_execute($stmt, OCI_COMMIT_ON_SUCCESS)) {
            $err = oci_error($stmt);
            throw new Exception(utf8_encode($err["message"]), 500);            
         } else {
            $resultAux = $result->load();
            if(Utils::hasValue($resultAux)) {
               $response["result"] = Utils::xmlToArray($resultAux);
               if(isset($response["result"]["fault"]["error"])) {

                  http_response_code(500);
                  $message = $request->isDebug() && Utils::hasValue($response["result"]["fault"]["stacktrace"]) ? $response["result"]["fault"]["message"] . "\n". $response["result"]["fault"]["stacktrace"] : $response["result"]["fault"]["message"];
                  $response = array(
                              "success" => false,
                              "code" => 500, 
                              "message" => $message,
                              "detail" => $response["result"]["fault"]
                           );
               }
            } else {
               //$response["result"] = array();
            }
         }
      }
   }

   // O header KMM-Platform ÃÂ© enviado para identificar qual plataforma estÃÂ¡ sendo executada
   //$response["KMM-Platform"] = $request->header("KMM-Platform");

   // ÃÂ debug se tem 1 no header "Debug"
   if($request->isDebug()) {
      $response["debug"] = $request->isDebug();
      $response["token"] = $token != null ? $token : $response["result"]["token"];
   }
} catch (Exception $e) {
   $code = $e->getCode();
   $message = $e->getMessage();
   if($code == 0 || !isset($code)) {
      $code = 500;
   }
   http_response_code($code);
   $response = array(
               "success" => false,
               "code" => $code, 
               "message" => $message
            );
}

// Printa o response
$request->showResponse($response);
