<?php
// https://pt.wikipedia.org/wiki/Lista_de_c%C3%B3digos_de_status_HTTP
require_once "Utils.class.php";

/**
 * Classe para converter os dados da requisição
 * @author Lukas Jacomin
 */
class Request {
   private $header = array();
   private $input = array();
   private $charset = "ISO-8859-1";
   private $compressionInput;
   private $compressionOutput;

   public function __construct() {
      $this->header = getallheaders();
   }
   
   public function handle() {
      if(!$this->isXML() && !$this->isJSON()) {
         throw new Exception("Somente aceitos requisições XML ou JSON.", 500);
         die();
      }
      $content = file_get_contents("php://input");

      if ($this->isXML()) {
         $content = mb_convert_encoding($content, "ISO-8859-1", mb_detect_encoding($content, "UTF-8, ISO-8859-1, ISO-8859-2, ISO-8859-10, ISO-8859-15", true));
      }

      if ($this->isInputZIP()){
        if ($this->$compressionInput === "zlib"){
            $content = gzuncompress($content);
        } else{
            throw new Exception("Método de compressão não disponível no header KMM-Input-Compression: "+$this->$compressionInput, 400);
        }
      }

      $this->isOutputZIP();

      if($this->isXML()) {
         $this->input = Utils::xmlToArray($content);
      } else {
         $this->input = Utils::jsonToArray($content);
      }
      if($this->input === NULL) {
         if($content === NULL || $content == "") {
            throw new Exception("Conteudo vazio fornecido", 204);
         } else {
            throw new Exception("Conteudo invalido fornecido", 206);
         }
      }
   }

   public function isInputZIP() {
        if ($this->header["KMM-Input-Compression"]) {
            $this->$compressionInput = $this->header["KMM-Input-Compression"];
            return TRUE;
        } else {
            return FALSE;
        }
    } 

    public function isOutputZIP() {
        if ($this->header["KMM-Output-Compression"]) {
            $this->$compressionOutput = $this->header["KMM-Output-Compression"];
            return TRUE;
        } else {
            return FALSE;
        }
    } 

   public function isXML() {
      if ($this->header["Content-Type"]) {
         return (strpos($this->header["Content-Type"], "application/xml") !== FALSE || strpos($this->header["Content-Type"], "text/xml") !== FALSE) ;
      } else {
         return (strpos($this->header["content-type"], "application/xml") !== FALSE || strpos($this->header["content-type"], "text/xml") !== FALSE) ;
      }
   }

   public function isJSON() {
      if ($this->header["Content-Type"]) {
         return strpos($this->header["Content-Type"], "application/json") !== FALSE;
      } else {
         return strpos($this->header["content-type"], "application/json") !== FALSE;
      }
   }

   public function input($key = null) {
      if(isset($key) && $key != "") {
         return $this->$key;
      } else {
         return $this->input;
      }
   }

   public function header($key = null) {
      if(isset($key) && $key != "") {
         return $this->header[$key];
      } else {
         return $this->header;
      }
   }

   // Headers para habilitar CORS - Cross-origin resource sharing
   public function responseHeaders() {
      header("Access-Control-Allow-Origin: *");
      header("Access-Control-Allow-Methods: POST");
      header("Access-Control-Allow-Headers: Content-Type, Debug, Authorization, Token-Time-Hours, KMM-Platform, KMM-Input-Compression, KMM-Output-Compression");
   }

   public function showResponse($response = array()) {
      $this->responseHeaders();
      if($this->isXML()) {
         header("Content-Type: text/xml; charset={$this->charset}");
         $responseConverted = Utils::arrayToXml($response);
      } else {
         header("Content-Type: application/json; charset={$this->charset}");
         $responseConverted = Utils::arrayToJson($response);
      }

      if ($this->isOutputZIP() && strlen($responseConverted) > 512){
        if ($this->getCompressionOutput() === "zlib"){
            $responseConverted = gzcompress($responseConverted);
            header("KMM-Compressed: true");
        } else{
            throw new Exception("Método de compressão não disponível no header KMM-Output-Compression: "+$$this->getCompressionOutput(), 400);
        }
      } else{
        header("KMM-Compressed: false");
      }

       echo $responseConverted;
   }

   public function isDebug() {
      return $this->header["Debug"] == 1;
   }
   
   public function getCompressionInput() {
      return $this->$compressionInput;
   }

   public function getCompressionOutput() {
      return $this->$compressionOutput;
   }

   // -- 
   public function __get($key) {
      return $this->input[$key];
   }

   public function __set($key, $value) {
      $this->input[$key] = $value;
   }
}
