<cfset session.usuario = 'kss'>
<cfset session.senha = ']]as+02'>
<cfset session.dsn = 'RODOMAR_KMM'>
<script src="/_scripts/engine_ajax.js"></script>
<script src="/_scripts/scripts_db.js"></script>
<script>
function Cabecalho(planilha) {
	this.parent = planilha;
	this.contentHead = document.createElement('THEAD');
	this.contentHeadTr = document.createElement('TR');
	this.contentOrigin = document.createElement('TD');
	with(this.contentOrigin) {
		className = 'p_nome_celula';
		innerHTML = '&nbsp;';
		width = '1%';
	}
	this.contentHeadTr.appendChild(this.contentOrigin);
	this.contentHead.appendChild(this.contentHeadTr);
	this.parent.contentTable.appendChild(this.contentHead);
	this.addColuna = function (position) {
		var td = document.createElement("TD");
		td.className = 'p_nome_celula';
		this.contentHeadTr.insertBefore(td,((this.contentHeadTr.cells[position] != null)?this.contentHeadTr.cells[position]:null));
		return td;
	}
}

function Coluna (planilha, position) {
	this.parent = planilha;
	this.id = null;
	if(!position) {
		position = this.parent.cabecalho.contentHeadTr.cells.length;
	}
	if(position > this.parent.cabecalho.contentHeadTr.cells.length) 
		position = this.parent.cabecalho.contentHeadTr.cells.length;
	this.position = position;
	this.head = this.parent.cabecalho.addColuna(position);
	this.head.coluna = this;
	this.seleciona = function() {
		this.head.className = 'p_nome_celula_select';
	}
	this.desseleciona = function () {
		this.head.className = 'p_nome_celula';
	}
	this.setId = function (value) {
		this.id = value;
		this.head.innerHTML = this.converteId(this.id);
	}
	this.converteId = function (id) {
		return String.fromCharCode(id+64)
	}
	this.getName = function () {
		return this.converteId(this.id);
	}
	this.setId(position);
}

function Linha (planilha, position) {
	this.parent = planilha;
	if(!position) {
		position = this.parent.contentBody.rows.length+1;
	}
	this.celulas = [];
	this.addCelula = function (celula) {
		this.celulas.push(celula);
	}
	this.contentTr = document.createElement("TR");
	this.contentTr.linha = this;
	this.origin = document.createElement("TD");
	this.contentTr.appendChild(this.origin);
	this.origin.className = 'p_nome_celula';
	this.parent.contentBody.insertBefore(this.contentTr,((this.parent.contentBody.rows[position] != null)?this.parent.contentBody.rows[position]:null));	
	for(var i=0;i<this.parent.colunas.length;i++) {
		this.celulas.push(new Celula(this.parent,this,this.parent.colunas[i]));
	}
	this.seleciona = function() {
		this.origin.className = 'p_nome_celula_select';
	}
	this.desseleciona = function () {
		this.origin.className = 'p_nome_celula';
	}
	this.setId = function (value) {
		this.id = value;
		this.origin.innerHTML = this.id;
	}
	this.getName = function () {
		return this.id;
	}
	this.setId(position);
}

function Celula(planilha, linha, coluna) {
	this.parent = planilha;
	this.master = planilha.master;
	this.linha = linha;
	this.coluna = coluna;
	this.contentTd = document.createElement("TD");
	this.editor = null;
	this.formula = '';
	this.valor = '';
	this.editando = false;
	with(this.contentTd) {
		setAttribute('celula',this);
		innerHTML = '&nbsp;';
		className = 'p_celula';
		onclick = function () {
			this.getAttribute('celula').seleciona();
		}
		ondblclick = function () {
			this.getAttribute('celula').edita();
		}
	}
	this.linha.contentTr.insertBefore(this.contentTd);
	this.desseleciona = function () {
		this.contentTd.className = 'p_celula';
		this.linha.desseleciona();
		this.coluna.desseleciona();
	}
	this.seleciona = function () {
		if(this.editando) {
			return;
		}
		if(this.parent.selection != null) {
			this.parent.selection.desseleciona();
		}
		this.contentTd.className = 'p_celula_select';
		this.linha.seleciona();
		this.coluna.seleciona();
		this.parent.setSelection(this);
//		this.parent.controlSelection.readOnly = false;
		this.master.controlSelection.focus();
	}
	this.edita = function () {
		if(this.master.readOnly) {
			return;
		}
		if(!this.editor) {
			this.editor = document.createElement('input');
			with(this.editor) {
				setAttribute('celula',this);
				type = 'text';
				value = this.formula;
				style.width = '100%';
				style.height = '100%';
				className = 'p_input';
				onblur = function() { 
					with(this.getAttribute('celula')) {
						setFormula(this.value);
						seleciona();
					}
				}
				onkeyup = function () {
					key = ((window.event)?window.event.keyCode:event.charCode);
					if(key == 13) {
						this.onblur();
					}
				}			
			}
		}
		this.contentTd.innerHTML = '';
		this.contentTd.appendChild(this.editor);
		this.editor.select();
		this.editando = true;
	}
	this.setFormula = function (value) {
		this.formula = value;
		this.setValor('...');
		this.editando = false;
		url = "/_transportes/consulta/cfc_planilha.cfc?method=ins_planilha_celula";
		p_arguments = 'planilha_id='+this.master.id+'&sheet_id='+this.parent.sheet_id+'&linha='+this.linha.getName()+'&coluna='+this.coluna.getName()+'&valor='+escape(value);
		f_query_wddx(url, p_arguments, this.wddxSetFormula, true, this);
	}
	this.wddxSetFormula = function (obj) {
		if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
			if(obj.struct.erro == 'false') {
				obj.referencia.setValor(obj.struct.result);
			} else { 
				alert('No foi possivel salvar o valor!');
				obj.referencia.setValor('#Erro!');
			}
		} else {
		   if ( obj.ajax.readyState == 4 ) {
		   		
		   }
		}
	}	
	this.setValor = function (value) {
		this.valor = value;
		this.contentTd.innerHTML = (String(value).replace(/ /g,'') == '')?'&nbsp;':value;
	}
	this.setFormulaValor = function (formula,valor) {
		this.formula = formula;
		this.setValor(valor);
	}
	linha.addCelula(this);
}

function PlanilhaSheet(planilha, sheet_id) {
	this.master = planilha;
	this.tr = null;
	this.aba = null;
	this.sheet_id = sheet_id;
	this.titulo = 'Orado - Maio 2006';
	this.selection = null;
	this.linhas = [];
	this.colunas = [];
	this.linhaRef = [];
	this.colunaRef = [];
	
	this.abaTr = document.createElement('tr');
	this.abaTrTd = document.createElement('td');
	with(this.abaTrTd) {
		className = 'p_aba_corpo';
	}
	this.abaTr.appendChild(this.abaTrTd);
	this.abaTr.style.display = 'none';

	this.abaTd = document.createElement("td");
	with(this.abaTd) {
		className = 'p_aba_down';
		width = '1%';
		innerHTML = '<nobr>'+this.titulo+'</nobr>';
		setAttribute('sheet',this);
		onclick = function () {
			sht = this.getAttribute('sheet');
			sht.seleciona();
			sht.linhas[0].celulas[0].seleciona();
		}
	}
	this.seleciona = function() {
		this.abaTr.style.display = '';
		this.abaTd.className = 'p_aba_up';
		if(this.master.sheetSelection != null && this.master.sheetSelection != this) {
			this.master.sheetSelection.desseleciona();
		}
		this.master.sheetSelection = this;
	}
	this.desseleciona = function() {
		this.abaTr.style.display = 'none';
		this.abaTd.className = 'p_aba_down';
	}
	this.setTitulo = function (value) {
		this.titulo = value;
		this.abaTd.innerHTML = '<nobr>'+this.titulo+'</nobr>';
	}
	this.contentTable = document.createElement('TABLE');
	with(this.contentTable) {
		cellPadding = 3;
		cellSpacing = 0;
//		className = 'p_aba_corpo';
		width = '100%';
	}
	this.contentBody = document.createElement('TBODY');
	this.contentTable.appendChild(this.contentBody);
//	this.master.contentDiv.appendChild(this.contentTable);
	this.cabecalho = new Cabecalho(this);
	
	/**
	 * Inicializa a planilha
	 */
	this.resize = function (linhas,colunas) {
		if(!linhas)
			linhas = 20;
		if(!colunas)
			colunas = 20;

		for(var i=0;i<colunas;i++) {
			this.colunas.push(new Coluna(this));
		}
		for(var i=0;i<linhas;i++) {
			this.linhas.push(new Linha(this));
		}
		this.resetIds();
	}
	/**
	 * Busca todos os valores da planilha no banco de dados
	 */
	this.refreshData = function () {
		if(document.readyState == 'complete') {
			url = "/_transportes/consulta/cfc_planilha.cfc?method=get_valores_planilha";
			p_arguments = "planilha_id="+this.master.id+"&sheet_id="+this.sheet_id;
			f_query_wddx(url, p_arguments, this.wddxData, true, this);
		} else {
			alert('No  possvel carregar os dados da planilha antes de terminado o carregamento da pagina! Por favor, clique em atualizar.');
		}
	}
	this.wddxData = function (obj) {
		if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
			for(var i=0;i<obj.struct.linha.length;i++) {
				obj.referencia.setValorCelula(obj.struct.linha[i],obj.struct.coluna[i],obj.struct.formula[i],obj.struct.valor[i]);
			}
		} 
	}
	this.setValorCelula = function (linha,coluna,formula,valor) {
		cel = this.getCelula(linha,coluna);
		if(cel != null) {
			cel.setFormulaValor(formula, valor);
		} else {
			alert('Celula no encontrada!');
		}
	}
	this.getCelula = function (linha, coluna) {
		for(var i=0;i<this.linhaRef[linha].celulas.length;i++) {
			if(this.linhaRef[linha].celulas[i].coluna == this.colunaRef[coluna]) {
				return this.linhaRef[linha].celulas[i];
			}
		}
		return null;
	}
	this.getCelulaById = function(linha,coluna) {
		return this.getCelula(this.linhas[linha].getName(), this.colunas[coluna].getName());
	}
	this.resetIds = function() {
		this.linhas = [];
		this.colunas = [];
		this.linhaRef = [];
		this.colunaRef = [];
		for(var i=1;i<this.cabecalho.contentHeadTr.cells.length;i++) {
			this.cabecalho.contentHeadTr.cells[i].coluna.setId(i);
			this.colunas.push(this.cabecalho.contentHeadTr.cells[i].coluna);
			this.colunaRef[this.cabecalho.contentHeadTr.cells[i].coluna.getName()] = this.cabecalho.contentHeadTr.cells[i].coluna;
		}
		for(var i=0;i<this.contentBody.rows.length;i++) {
			this.contentBody.rows[i].linha.setId(i+1);
			this.linhas.push(this.contentBody.rows[i].linha);
			this.linhaRef[this.contentBody.rows[i].linha.getName()] = this.contentBody.rows[i].linha;
		}
		this.linhas[0].celulas[0].seleciona();
	}
	this.setSelection = function (celula) {
		this.selection = celula;
		this.master.controlFormula.value = celula.formula;
		this.master.controlSelection.value = celula.coluna.getName()+celula.linha.getName();
		this.master.controlSelection.focus();
		
	}
	this.moveLeft = function() {
		this.move(1,0);
	}
	this.moveUp = function() {
		this.move(0,-1);
	}
	this.moveRight = function() {
		this.move(-1,0);
	}
	this.moveDown = function() {
		this.move(0,1);
	}
	this.move = function(left, down) {
		if(this.selection == null) {
			return;
		}
		linha = this.selection.linha.id + down ;
		coluna = this.selection.coluna.id - left;
		if(linha < 1 || coluna < 1) {
			return;
		}
		if(linha > this.linhas.length) {
			this.linhas.push(new Linha(this));
			this.resetIds();
		}
		if(coluna > this.colunas.length) {
			this.colunas.push(new Coluna(this));
			this.resetIds();
		}
		this.selection.desseleciona();
		this.getCelulaById(linha-1,coluna-1).seleciona();
	}
	this.getObject = function () {
		return this.contentTable;
	}
	this.abaTrTd.appendChild(this.contentTable);
}

function PlanilhaControl(planilha) {
	this.master = planilha;
	this.controlTable = document.createElement('TABLE');
	with(this.controlTable) {
		width = '100%';
		border = "0";
		cellPadding = "2";
		cellSpacing = "1";
		className = "texto";		
	}
	this.controlTableBody = document.createElement('TBODY');
	this.controlTableTr = document.createElement('TR');
	var v_td = document.createElement("td");
	with(v_td) {
		width="10";
		align="left";
		valign="middle";
	}
	var v_btn = document.createElement('button');
	with(v_btn) {
		className = 'botao-16x16';
		style.padding = 0;
		title = 'Atualizar Dados...';
		setAttribute('control',this);
		onclick = function () {
			ctrl = this.getAttribute('control');
			ctrl.master.refreshData();
		}
	}
	var v_img = document.createElement('img');
	v_img.width = 16;
	v_img.height = 16;
	v_img.align = 'absmiddle';
	v_img.src = '/_imagens/botoes/16x16/atualizar.gif';
	v_btn.appendChild(v_img);
	v_td.appendChild(v_btn);
	this.controlTableTr.appendChild(v_td);
	var v_td = document.createElement("td");
	with(v_td) {
		width="10";
		align="left";
		valign="middle";
		innerHTML = 'C&eacute;lula:';
	}
	this.controlTableTr.appendChild(v_td);
	var v_td = document.createElement("td");
	with(v_td) {
		width="80";
		align="left";
		valign="middle";
	}
	this.controlSelection = document.createElement("input");
	with(this.controlSelection) {
		setAttribute('planilha', this);
		type = 'text';
		style.width = '50px';
		readOnly = true;
		onkeyup = function () {
			key = ((window.event)?window.event.keyCode:event.charCode);
			plan = this.getAttribute('planilha');
			switch(key) {
				case 13:
					if(plan.selectedSheet.selection != null) 
						plan.selectedSheet.selection.edita();
					break;
				case 37: //left
					plan.selectedSheet.moveLeft();
					break;
				case 38: //up
					plan.selectedSheet.moveUp();
					break;
				case 39: //right
					plan.selectedSheet.moveRight();
					break;
				case 40: //down
					plan.selectedSheet.moveDown();
					break;
			}
		}
	}
	v_td.appendChild(this.controlSelection);
	this.controlTableTr.appendChild(v_td);
	var v_td = document.createElement("td");
	with(v_td) {
		width="20";
		align="right";
		valign="middle";
		innerHTML = '<img src="/_imagens/botoes/16x16/fx.gif" width="16" height="16" align="absmiddle">';
	}
	this.controlTableTr.appendChild(v_td);
	var v_td = document.createElement("td");
	with(v_td) {
		align="left";
		valign="middle";
	}
	this.controlFormula = document.createElement("input");
	with(this.controlFormula) {
		type = 'text';
		setAttribute('planilha', this);
		style.width = '100%';
		onchange = function () {
			plan = this.getAttribute('planilha');
			plan.selection.setFormula(this.value);
		}
		onkeyup = function () {
			key = ((window.event)?window.event.keyCode:event.charCode);
			if(key == 13) {
				this.onchange();
			}
		}
	}
	v_td.appendChild(this.controlFormula);
	this.controlTableTr.appendChild(v_td);
	this.controlTableBody.appendChild(this.controlTableTr);
	this.controlTable.appendChild(this.controlTableBody);
	this.master.contentDiv.appendChild(this.controlTable);	
	
}

function Planilha(planilha_id) {
	this.id = planilha_id;
	this.readOnly = false;
	this.contentDiv = document.createElement("DIV");
	this.sheets = [];
	this.control = new PlanilhaControl(this);
	this.controlSelection = this.control.controlSelection;
	this.controlFormula = this.control.controlFormula;
	this.setReadOnly = function (value) {
		this.controlFormula.readOnly = value;
		this.readOnly = value;
	}
	this.sheetTable = document.createElement("table");
	this.selectedSheet = null;
	with(this.sheetTable) {
		width = '100%';
		cellPadding = 0;
		cellSpacing = 0;
	}
	this.sheetBody = document.createElement("tbody");
	this.sheetFoot = document.createElement("Tfoot");
	this.sheetFootTr = document.createElement("TR");
	this.sheetFootBtn = document.createElement("TD");
	with(this.sheetFootBtn) {
		className = 'p_aba_none';
		width = 10;
		style.padding = 0;
	}	
	var v_btn = document.createElement('button');
	with(v_btn) {
		className = 'botao-16x16';
		style.padding = 0;
		setAttribute('control',this);
		onclick = function () {
			ctrl = this.getAttribute('control');
//			ctrl.master.refreshData();
		}
	}
	var v_img = document.createElement('img');
	v_img.width = 16;
	v_img.height = 16;
	v_img.align = 'absmiddle';
	v_img.src = '/_imagens/botoes/16x16/voltar_primeira.gif';
	v_btn.appendChild(v_img);
	this.sheetFootBtn.appendChild(v_btn);

	var v_btn = document.createElement('button');
	with(v_btn) {
		className = 'botao-16x16';
		style.padding = 0;
		style.margin = 0;
		setAttribute('control',this);
		onclick = function () {
			ctrl = this.getAttribute('control');
//			ctrl.master.refreshData();
		}
	}
	var v_img = document.createElement('img');
	v_img.width = 16;
	v_img.height = 16;
	v_img.align = 'absmiddle';
	v_img.src = '/_imagens/botoes/16x16/voltar_um.gif';
	v_btn.appendChild(v_img);
	this.sheetFootBtn.appendChild(v_btn);

	var v_btn = document.createElement('button');
	with(v_btn) {
		className = 'botao-16x16';
		style.padding = 0;
		setAttribute('control',this);
		onclick = function () {
			ctrl = this.getAttribute('control');
//			ctrl.master.refreshData();
		}
	}
	var v_img = document.createElement('img');
	v_img.width = 16;
	v_img.height = 16;
	v_img.align = 'absmiddle';
	v_img.src = '/_imagens/botoes/16x16/avancar_um.gif';
	v_btn.appendChild(v_img);
	this.sheetFootBtn.appendChild(v_btn);

	var v_btn = document.createElement('button');
	with(v_btn) {
		className = 'botao-16x16';
		style.padding = 0;
		setAttribute('control',this);
		onclick = function () {
			ctrl = this.getAttribute('control');
//			ctrl.master.refreshData();
		}
	}
	var v_img = document.createElement('img');
	v_img.width = 16;
	v_img.height = 16;
	v_img.align = 'absmiddle';
	v_img.src = '/_imagens/botoes/16x16/avancar_ultima.gif';
	v_btn.appendChild(v_img);
	this.sheetFootBtn.appendChild(v_btn);

	this.sheetFootBtn.width = '1%';
	this.sheetFootTr.appendChild(this.sheetFootBtn);

	this.sheetFootNone = document.createElement("TD");
	this.sheetFootNone.className = 'p_aba_none';
	this.sheetFootNone.innerHTML = '&nbsp;';

	this.sheetFootTr.appendChild(this.sheetFootNone);
	this.sheetTable.appendChild(this.sheetBody);
	this.sheetFoot.appendChild(this.sheetFootTr);
	this.sheetFootTr.appendChild(this.sheetFootNone);
	this.sheetTable.appendChild(this.sheetFoot);
	this.contentDiv.appendChild(this.sheetTable);
	
	//Cria os botoes de navegao das abas
	
//    <td class="p_aba_none" width="16"><button class="botao-16x16" style="width:20px" type="button" title="Ir para primeira planilha "><img src="/_imagens/botoes/16x16/voltar_primeira.gif" width="16" height="16" align="absmiddle"></button></td>
	
	
	/**
	 * Insere a planilha no sistema.
	 */
	this.write = function () {
		document.write('<div id="dv_excel_'+this.id+'"></div>');
		document.getElementById('dv_excel_'+this.id).appendChild(this.contentDiv);
	}
	/**
	 * Retorna o objeto principal da planilha
	 */
	this.getObject = function () {
		return this.contentDiv;
	}
	/**
	 * Insere uma nova sheet na planilha
	 */
	this.addSheet = function (sheet_id,titulo) {
		this.sheets.push(new PlanilhaSheet(this, sheet_id));
		sht = this.sheets[this.sheets.length-1];
		sht.setTitulo(titulo);
		this.sheetBody.appendChild(sht.abaTr);
		this.sheetFootTr.insertBefore(sht.abaTd,this.sheetFootNone);
		for(var i=0;i<this.sheets.length;i++) {
			this.sheets[i].abaTrTd.colSpan = this.sheets.length+2;
		}
		if(this.sheets.length == 1) {
			sht.seleciona();
		}
		return sht;
	}
	/**
	 * Busca a sheet pelo seu sheet_id
	 */
	this.getSheet = function(sheet_id) {
		for(var i=0;i<this.sheets.length;i++) {
			if(this.sheets[i].sheet_id == sheet_id) {
				return this.sheets[i];
			}
		}
		return null;
	}
	/**
	 * Atualiza os dados da planilha em todas as suas sheets
	 */
	this.refreshData = function () {
		if(document.readyState == 'complete') {
			url = "/_transportes/consulta/cfc_planilha.cfc?method=get_valores_planilha";
			p_arguments = "planilha_id="+this.id;
			f_query_wddx(url, p_arguments, this.wddxData, false, this);
		} else {
			alert('No  possvel carregar os dados da planilha antes de terminado o carregamento da pagina! Por favor, clique em atualizar.');
		}
	}
	this.wddxData = function (obj) {
		if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
			for(var i=0;i<obj.struct.sheet.length;i++) {
				sheet = obj.referencia.getSheet(obj.struct.sheet_id[i]);
				if(obj.struct.linha[i] != '') {
					sheet.setValorCelula(obj.struct.linha[i],obj.struct.coluna[i],obj.struct.formula[i],obj.struct.valor[i]);
				}
				sheet.setTitulo(obj.struct.sheet[i]);
			}
		} 
	}	
}

</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Planilha Eletr&ocirc;nica</title>
<link href="/_estilos/planilha_eletronica.css" rel="stylesheet" type="text/css">
<link href="/_estilos/tags.css" rel="stylesheet" type="text/css">
<link href="/_estilos/class.css" rel="stylesheet" type="text/css">
</head>

<body onLoad="">
<form action="" method="post" name="form_plan">
<script>
	plan1 = new Planilha(33);
	plan1.addSheet(1);
	plan1.addSheet(2);
	plan1.sheets[0].resize(1100,1100);
	plan1.sheets[1].resize(20,20);
	plan1.write();
//	plan1.setReadOnly(true);
</script>
</form>
<div id="erro"></div>
</body>
</html>
