<?php
//Este arquivo serve para a execuo e criao dos comandos basicos de todas as paginas
include_once($_SERVER['DOCUMENT_ROOT']."/_class/classes/dBug.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/mail.php");
include_once("data_sources.php");

function scope_start() {
	global $variaveis_globais;
	$variaveis_globais = array();
	foreach($GLOBALS as $key => $value) {
		$variaveis_globais[$key] = true;
	}
}

function scope_end() {
	global $variaveis_globais;
	foreach($GLOBALS as $key => $value) {
		if(!isset($variaveis_globais[$key])) {
//		   print("<!-- Limpando a Variavel: ".$key." -->\n");
		   global $$key;
		   unset($$key);
		   unset($GLOBALS[$key]);
		}
	}
	unset($GLOBALS['variaveis_globais']);
	unset($variaveis_globais);
}
if(!class_exists("BC_Timer")) {
	class BC_Timer{ 
		var $stime; 
		var $etime; 
		var $smemory;
		var $ememory;
		function BC_Timer(){ 
			$this->stime = $this->get_microtime(); 
			$this->smemory = memory_get_usage();
		} 
		function get_microtime() { 
			$tmp = explode(' ',microtime());  
			return $tmp[0]+$tmp[1]; 
		} 
		function elapsed_time(){ 
			$this->etime = $this->get_microtime(); 
			echo "<small><p align=center>[ Carregado em : ". round(($this->etime - $this->stime),4) ." segundo(s)]</p></small>"; 
		} 
		function get_elapsed_time() {
			$this->etime = $this->get_microtime(); 
			return $this->etime - $this->stime;
		}
		function get_used_memory() {
			$this->ememory = memory_get_usage();
			return $this->ememory - $this->smemory;
		}
	} 
}

function printr($text) {
	print(stripslashes($text));
}

function limpatags($text) {
	return preg_replace("(<[^>]*>)",'',$text);
}

function toUpper($string) { 
    return (strtoupper(strtr($string, 'easlzzcn','EASLZZCN' ))); 
} 

function toLower($string) { 
    return (strtolower(strtr($string,'EASLZZCN', 'easlzzcn' ))); 
}

function xmlentities($text) {
	return str_replace('"','&quot;',str_replace('>','&gt;',str_replace('<','&lt;',str_replace('&','&amp;',$text))));
}

function textcut($text,$length,$excededtext="") {
	if($length == 0)
		return "";
		
	$text = strlen(trim($text)) ? $text : '';
	// Reduz o tamanho da String para evitar travamentos
	$textfinal = limpatags(substr($text,0,$length+2500));
	
	$result = substr($textfinal,0,$length+0);
	$fim = substr($textfinal,$length,200);
	if(substr($fim,1) == " ") 
		$result = $result." ";
	$words = explode(" ",$fim);
	if(count($words) > 0) {
		$result = $result.$words[0];
	}
	if(strlen($textfinal) > strlen($result)) {
		$result .= $excededtext;
	}
	return trim($result);
}

function getArrayXML($array) {
	$result = "";
	if(is_array($array)) {
		foreach($array as $key => $value) {
			$result .= "<$key>".getArrayXML($value)."</$key>";
		}
	} else {
		$result = xmlentities($array);
	}
	return $result;
}

function JSStringFormat($text) {
	$result = str_replace(chr(13).chr(10),'\n',$text);
	$result = str_replace(chr(10),'\n',$result);
	$result = str_replace(chr(13),'\n',$result);
	$result = str_replace("'","\\'",$result);
	$result = str_replace("\\\\'","\\'",$result);
	$result = str_replace("
","\n",$result);
	return $result;
}

function lsdateformat($strdata,$format) {
	if(!strlen(trim($strdata)))
		return "";
	$parts = explode(" ",$strdata);
	$parts1 = explode("/",$parts[0]);
	$parts2 = explode(":",$parts[1]);
	if(!strlen(trim($parts[1])))
		$parts2 = array(0,0,0);
	$result = date($format,mktime($parts2[0],$parts2[1],$parts2[2],$parts1[1],$parts1[0],$parts1[2]));
	if(strpos($format,"D") !== false) {
		$result = str_replace("Sun","Domingo",$result);
		$result = str_replace("Mon","Segunda-Feira",$result);
		$result = str_replace("Tue","Tera-Feira",$result);
		$result = str_replace("Wed","Quarta-Feira",$result);
		$result = str_replace("Thu","Quinta-Feira",$result);
		$result = str_replace("Fri","Sexta-Feira",$result);
		$result = str_replace("Sat","Sbado",$result);
	}
	if(strpos($format,"M") !== false) {
		$result = str_replace("Jan","Janeiro",$result);
		$result = str_replace("Feb","Fevereiro",$result);
		$result = str_replace("Mar","Maro",$result);
		$result = str_replace("Apr","Abril",$result);
		$result = str_replace("May","Maio",$result);
		$result = str_replace("Jun","Junho",$result);
		$result = str_replace("Jul","Julho",$result);
		$result = str_replace("Aug","Agosto",$result);
		$result = str_replace("Sep","Setembro",$result);
		$result = str_replace("Oct","Outubro",$result);
		$result = str_replace("Nov","Novembro",$result);
		$result = str_replace("Dec","Dezembro",$result);
	}
	return $result;
}

// Retorna uma String com o conteudo de um include
function get_include_contents($filename) {
	global $_VARS;
    if (is_file($filename)) {
        ob_start();
        include $filename;
        $contents = ob_get_contents();
        ob_end_clean();
        return $contents;
    }
    return false;
}

// Realiza o tratamento de erros
function fnc_trata_erros($arguments) {
	global $_VARS;
	if($arguments['struct']['erro'] == "true") {
		$erro = array();
		$erro['Ambiente'] = get_error_details();
		$erro['Detalhes'] = $arguments['struct']['mensagem'];
		$erro['Variaveis'] = $_VARS;
		$erro['Sessao'] = $_SESSION;
		print("<form name='form_error' method='post' action=''>");
		fnc_dump_inputs('Erro',$erro);
		print("</form>");
?>
<script src="/_scripts/scripts_db.js"></script>
<script>
	with(document.form_error) {
		NewWindow('about:blank','php_msg_erro',750,400,'yes');
		target = 'php_msg_erro';
		action = '/publico/mensagem_erro.php';
		method = 'post';
		submit(); 
	}
//	alert('Erro: <?php print(str_replace("'", "\\'", str_replace(chr(13), "", str_replace(chr(10),"\\n", $arguments["struct"]["mensagem"]['message'])))); ?>');
</script>
<?php
		die("");
	} else {
		if(!isset($arguments['mostra_msg_ok']) || $arguments['mostra_msg_ok']) {
?>
<script>
	alert('<?php print(str_replace("'", "\\'", str_replace(chr(13), "", str_replace(chr(10),"\\n", $arguments["struct"]["mensagem"])))); ?>');
</script>
<?php
		}
	}
}

function fnc_trata_msg_erro($msg){
	$retorno = substr($msg, 10, strlen($msg));
	if( strpos($retorno,"ORA") >= 0 )
		$retorno = substr($retorno, 0, strpos($retorno,"ORA"));
	return $retorno;
}


// Realiza o tratamento de erros
function fnc_trata_erros_site($arguments) {
	global $_VARS;
	if($arguments['struct']['erro'] == "true") {
		$erro = array();
		$erro['Ambiente'] = get_error_details();
		$erro['Detalhes'] = $arguments['struct']['mensagem'];
		$erro['Variaveis'] = $_VARS;
		$erro['Sessao'] = $_SESSION;
		//new dBug($erro);
		/*print("<form name='form_error' method='post' action=''>");
		fnc_dump_inputs('Erro',$erro);
		print("</form>");*/
?>
<script src="/_scripts/scripts_db.js"></script>
<script>
	f_erro_execucao('<?php print( fnc_trata_msg_erro(str_replace( chr(10),"<br>", str_replace( chr(13),'', $erro['Detalhes']['message']) ) ) ); ?>');
	/*with(document.form_error) {
		NewWindow('about:blank','php_msg_erro',750,400,'yes');
		target = 'php_msg_erro';
		action = '/publico/mensagem_erro.php';
		method = 'post';
		submit(); 
	}*/
	//alert('Erro: <?php print(str_replace("'", "\\'", str_replace(chr(13), "", str_replace(chr(10),"\\n", $arguments["struct"]["mensagem"]['message'])))); ?>');
</script>
<?php
		die("");
	} else {
		if(!isset($arguments['mostra_msg_ok']) || $arguments['mostra_msg_ok']) {			
?>
<script>
	f_mensagem_execucao('<?php print(str_replace("'", "\\'", str_replace(chr(13), "", str_replace(chr(10),"\\n", $arguments["struct"]["mensagem"])))); ?>','<?php print($arguments['reposicionar']); ?>');
//	alert('<?php print(str_replace("'", "\\'", str_replace(chr(13), "", str_replace(chr(10),"\\n", $arguments["struct"]["mensagem"])))); ?>');
</script>
<?php
		}
	}
}

function fnc_dump_inputs($name,$struct) {
	if(is_array($struct)) {	
		foreach($struct as $var => $value) {
			fnc_dump_inputs($name."[".$var."]",$value);
		}
	} else if(is_string($struct)) {
 		print("\t<input name='$name' type=hidden value=\"".str_replace('"','&quot;',$struct)."\">\n");
	}
}

function nvl($value,$result) {
	return (trim($value) == '')?$result:$value;
}

function printUrl($url) {
	global $_SESSION;
	if(file_exists($_SERVER['DOCUMENT_ROOT']."/".$_SESSION['site'].$url))
		print(str_replace("//","/","/".$_SESSION['site'].$url));
	else
		print($url);
}

/**
  * Retorna a estrutura de detalhamento do erro
  */
function get_error_details() {
	$retorno = array();
	// Dados da Requisio
	$retorno['Requisio']['Local de Origem'] = $_SERVER['HTTP_REFERER'];
	$retorno['Requisio']['Navegador'] = $_SERVER['HTTP_USER_AGENT'];
	$retorno['Requisio']['Host Acessado'] = $_SERVER['HTTP_HOST'];
	$retorno['Requisio']['IP do Cliente'] = $_SERVER['REMOTE_ADDR'];
	$retorno['Requisio']['Arquivo Executado'] = $_SERVER['SCRIPT_FILENAME'];
	$retorno['Requisio']['Method'] = $_SERVER['REQUEST_METHOD'];
	$retorno['Requisio']['Query String'] = $_SERVER['QUERY_STRING'];
	$retorno['Requisio']['Local'] = $_SERVER['SCRIPT_NAME'];
	$retorno['Requisio']['URL'] = $_SERVER['REQUEST_URI'];
	$retorno['Requisio']['Data'] = date("d/m/Y H:i:s",$_SERVER['REQUEST_TIME']);

	// Dados do Servidor
	$retorno['Servidor']['Language'] = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
	$retorno['Servidor']['Software do Servidor'] = $_SERVER['SERVER_SOFTWARE'];
	$retorno['Servidor']['Nome do Servidor'] = $_SERVER['SERVER_NAME'];
	$retorno['Servidor']['Gateway Interface'] = $_SERVER['GATEWAY_INTERFACE'];
	$retorno['Servidor']['Protocolo do Servidor'] = $_SERVER['SERVER_PROTOCOL'];
	$retorno['Servidor']['Arquivo'] = $_SERVER['PHP_SELF'];
	$retorno['Servidor']['Accept'] = $_SERVER['HTTP_ACCEPT'];

	// Dados da Sesso
	$retorno['Sesso']['PHPSESSID'] = $_REQUEST['PHPSESSID'];
	$retorno['Sesso']['Usurio'] = $_SESSION['usuario'];
	$retorno['Sesso']['Senha'] = $_SESSION['senha'];
	$retorno['Sesso']['Pasta do Site'] = $_SESSION['site'];
	$retorno['Sesso']['DSN'] = $_SESSION['dsn'];
	$retorno['Sesso']['Tipo de BD'] = $_SESSION['conexao']['DBTYPE'];
	$retorno['Sesso']['Sesso Conectada'] = $_SESSION['conexao']['CONNECTED'];
	global $_VARS;
	$retorno['Parametros'] = $_VARS;
	return $retorno;
}

//Abre uma conexao com o banco de dados
function connect($dsn,$username,$password) {
	global $dsns;
	
	if(strtolower($username) == 'publico' && $_SESSION['dsn'] == 'KMM.KMM.COM.BR')
		$password = 'kmm2006';		
	
	if(isset($dsns[$dsn])) {
		$_SESSION['STARTED_TRANSACTION'] = false;
		switch($dsns[$dsn]["DBTYPE"]) {
			case "oracle":
				$conexao = array();
				$conexao["DBTYPE"] = "oracle";
				$conexao["STARTED_TRANSACTION"] = false;

				if($conexao["CONNECTION"] = @oci_connect($username,$password,$dsns[$dsn]["TNS"])) {
					$conexao["CONNECTED"] = true;
					
					$query = "SET ROLE KSS_CORPORATIVO IDENTIFIED BY \"()#3F20L13RJ@\"";
					$stmt = oci_parse($conexao["CONNECTION"], $query);
					oci_execute($stmt,OCI_DEFAULT);
					
					// Seta a gesto se necessrio
					if($dsns[$dsn]['POSSUI_GESTAO'] == 1) {
						$query = "delete kss.pessoa_usuario_acesso_cur";
						$stmt = oci_parse($conexao["CONNECTION"], $query);
						oci_execute($stmt,OCI_DEFAULT);
						$query = "insert into kss.pessoa_usuario_acesso_cur
						             (cod_pessoa, usuario)
								  select cod_pessoa as cod_pessoa, 
										 user as usuario 
									from kss.pessoa_unidade_negocio 
			                       where cod_gestao in (".$dsns[$dsn]['COD_GESTAO'].")";
						$stmt = oci_parse($conexao["CONNECTION"], $query);
						oci_execute($stmt,OCI_DEFAULT);
						
						
					}
					
					// Habilita a role de acesso ao site
//					$stmt = oci_parse($conexao["CONNECTION"],"SET ROLE KSS_SITE IDENTIFIED BY kmm2007");
//					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
				} else {
					$conexao['ERROR'] = oci_error();
					$conexao["CONNECTED"] = false;
				}

				return $conexao;
				break;
			case "postgresql":
				$conexao = array();
				$conexao["DBTYPE"] = "postgresql";
				$conexao["STARTED_TRANSACTION"] = false;
				if($conexao["CONNECTION"] = pg_connect($dsns[$dsn]["CONNECTSTRING"]." user='".strtolower($username)."' password='".$password."'")) {
					$conexao["CONNECTED"] = true;
					if($dsns[$dsn]["CLIENTENCODING"]) {
						pg_set_client_encoding($conexao["CONNECTION"], $dsns[$dsn]["CLIENTENCODING"]);
					}
				} else {
					$conexao["CONNECTED"] = false;
					$conexao["CONNECTSTRING"] = $dsns[$dsn]["CONNECTSTRING"]." user='".$username."' password='".$password."'";
				}
				return $conexao;
				break;
		}
	} else {
		die("DSN ".$dsn." no cadastrado!");
		return false;
	}
}

function disconnect($conexao) {
	@oci_close($conexao["CONNECTION"]);
}

function listatoarray($vars,$field) {
	$result = array();
	foreach($vars as $key => $value) {
//		print($field."- ".strpos($key,$field."_")."<br>");
		if((!(strpos($key,$field."_") === false)) && strpos($key,$field."_") == 0) {
			array_push($result,$value);
		}
	}
	return $result;
}

function listdiff($lista1,$lista2) {
	$ar_lista1 = explode(",",$lista1);
	$ar_lista2 = explode(",",$lista2);
	$ar_result = array();
	for($i=0;$i<count($ar_lista1);$i++) {
		if(array_search($ar_lista1[$i],$ar_lista2) === false) {
			array_push($ar_result,$ar_lista1[$i]);
		}
	}
	return implode(",",$ar_result);
}

function WDDXtoArray($wddx) {
	$xml = new SimpleXMLElementExtended($wddx);
	$recordset = $xml->data[0]->recordset[0];
	if(isset($recordset)) {
		$attributes = array();
		foreach($recordset->attributes() as $a => $b) {
			$attributes[$a] = $b;
		}
		$fields = explode(',',$attributes['fieldNames']);
		$numFields = count($fields);
		$numRows = number_format($attributes['rowCount']);
		$result = array();
		for($i=0;$i<$numRows;$i++) {
			$j=0;
			foreach($fields as $field) {
				foreach ($recordset->field[$j]->children() as $value) {
					$result[$i][$field] = $value."";
				}
				$j++;
			}
		}
	} else {
		$result = array();
		$j=0;
		while($xml->data->struct->var[$j]."") {
			$at = $xml->data->struct->var[$j]->attributes();
			$nome = $at['name']."";
//			foreach($var->children() as $a => $b) {
				$result[$nome] = $xml->data->struct->var[$j]."";
//			}
		}
//		$var = $xml->data->struct->var[1]->attributes();
//		foreach($var->children() as $a => $b) {
//			$result[$a] = $b;
//		}
	}
	return $result;
}

class FieldCom {
	var $field;
	public function __construct($value_field) {
		$this->field = $value_field;
	}
	public function __toString() {
		return $this->field->load();
	}
}

// Classe base das operaes de banco do sistema (Comparavel aos componentes do Coldfusion)
class QueryCom {
	var $query, $conexao, $result, $dbtype, $startedTransaction = false;
	public $connection;
	function QueryCom (&$conexao) {
		$this->connection = &$conexao;
		$this->conexao = $conexao["CONNECTION"];
		$this->dbtype = $conexao["DBTYPE"];
		$this->connected = $conexao["CONNECTED"];
	}
	function setConexao(&$conexao) {
		$this->connection = &$conexao;
		$this->conexao = $conexao["CONNECTION"];
		$this->dbtype = $conexao["DBTYPE"];
		$this->connected = $conexao["CONNECTED"];
	}
	function getArray($result) {
		$final = array();
		$this->connection['started_transaction'] = "1";
		switch($this->dbtype) {
			case "oracle":
				$nColunas = oci_num_fields($result);
				$i = 0;
				while(oci_fetch($result)) {
					for($j=1;$j<=$nColunas;$j++) {
						if(oci_field_type($result, $j) == 'CLOB') {
							$v_value_field = oci_result($result,oci_field_name($result, $j));
//							new dBug($v_value_field->load());
							if($v_value_field != "") {
								$final[$i][oci_field_name($result, $j)] = $v_value_field->load();
//								$final[$i][oci_field_name($result, $j)] = new FieldCom($v_value_field);
							} else {
								$final[$i][oci_field_name($result, $j)] = "";
							}
						} elseif(oci_field_type($result, $j) == 'BLOB') {
							$v_value_field = oci_result($result,oci_field_name($result, $j));
							if($v_value_field != "") {
								$final[$i][oci_field_name($result, $j)] = base64_encode($v_value_field->load());
							} else {
								$final[$i][oci_field_name($result, $j)] = "";
							}
						} elseif(oci_field_type($result, $j) == 'NUMBER' || oci_field_type($result, $j) == 'INTEGER') {
							$final[$i][oci_field_name($result, $j)] = str_replace(',','.',oci_result($result,oci_field_name($result, $j)));
						} else {
							$final[$i][oci_field_name($result, $j)] = oci_result($result,oci_field_name($result, $j));
						}
					}
					$i++;
				}
				break;
			case "postgresql":
			default:
				$nColunas = pg_num_fields($result);
				$nLinhas = pg_num_rows($result);
				for($i=0;$i<$nLinhas;$i++) {
					for($j=0;$j<$nColunas;$j++) {
						$final[$i][strtoupper(pg_field_name($result, $j))] = pg_result($result, $i, pg_field_name($result, $j));
					}
				}
				break;
		}
		return $final;
	}
	function getWDDX($result) {
		$final = "<wddxPacket version='1.0'><header/><data>";
		switch($this->dbtype) {
			case "oracle":
				
				$nColunas = oci_num_fields($result);
				$array = $this->getArray($result);
				$nLinhas = count($array);
				$final .= "<recordset rowCount='$nLinhas' fieldNames='";
				for($j=1;$j<=$nColunas;$j++) {
					if($j != 1) {
						$final .= ",";
					}
					$final .= strtoupper(oci_field_name($result,$j));
				}
				$final .= "' type='php.sql.QueryTable'>";
				for($j=1;$j<=$nColunas;$j++) {
					$final .= "<field name='".strtoupper(oci_field_name($result,$j))."'>";
					switch(oci_field_type($result,$j)) {
						case "int8":
						case "int2":
						case "int4":
						case "float8":
						case "INTEGER":
						case "NUMBER":
						case "money":
							$tipo = "<number>";
							$tipo_final = "</number>";
							break;
						case "VARCHAR2":
						case "VARCHAR":
						case "CHAR":
						case "CLOB":
						case "time":
						case "timetz":
							$tipo = "<string>";
							$tipo_final = "</string>";
							break;
						case "bool":
						case "bit":
							$tipo = "<boolean>";
							$tipo_final = "</boolean>";
							break;
						case "date":
						case "timestamp":
						case "timestamptz":
							$tipo = "<dateTime>";
							$tipo_final = "</dateTime>";
							break;
						default:
							$tipo = "<".oci_field_type($result,$j).">";
							$tipo_final = "</".oci_field_type($result,$j).">";
							break;
					}
					for($i=0;$i<$nLinhas;$i++) {
						if(oci_field_is_null($result,oci_field_name($result, $j))) {
							$final .= "<null/>";
						} else {
							/*if(oci_field_type($result,$j) == 'BLOB') {
								$final .= $tipo.(base64_encode($array[oci_field_name($result, $j)][$i])).$tipo_final;
							} elseif(oci_field_type($result,$j) == 'CLOB') {
								$value_field = oci_result($result,oci_field_name($result, $j));// $array[oci_field_name($result, $j)][$i];
								
								new dBug($value_field);
								$final .= $tipo.($value_field).$tipo_final;
							} else {*/
								$final .= $tipo.xmlentities($array[$i][oci_field_name($result, $j)]).$tipo_final;
							//}
						}
					}
					$final .= "</field>";
				}
				$final .= "</recordset>";
				break;
			case "postgresql":
				$nColunas = pg_num_fields($result);
				$nLinhas = pg_num_rows($result);
				$final .= "<recordset rowCount='$nLinhas' fieldNames='";
				for($j=0;$j<$nColunas;$j++) {
					if($j != 0) {
						$final .= ",";
					}
					$final .= strtoupper(pg_field_name($result,$j));
				}
				$final .= "' type='php.sql.QueryTable'>";
				for($j=0;$j<$nColunas;$j++) {
					$final .= "<field name='".strtoupper(pg_field_name($result,$j))."'>";
					switch(pg_field_type($result,$j)) {
						case "int8":
						case "int2":
						case "int4":
						case "float8":
						case "float4":
						case "numeric":
						case "money":
							$tipo = "<number>";
							$tipo_final = "</number>";
							break;
						case "varchar":
						case "bpchar":
						case "text":
						case "time":
						case "timetz":
							$tipo = "<string>";
							$tipo_final = "</string>";
							break;
						case "bool":
						case "bit":
							$tipo = "<boolean>";
							$tipo_final = "</boolean>";
							break;
						case "date":
						case "timestamp":
						case "timestamptz":
							$tipo = "<dateTime>";
							$tipo_final = "</dateTime>";
							break;
						default:
							$tipo = "<".pg_field_type($result,$j).">";
							$tipo_final = "</".pg_field_type($result,$j).">";
							break;
					}
					for($i=0;$i<$nLinhas;$i++) {
						if(pg_field_is_null($result,$i,$j)) {
							$final .= "<null/>";
						} else {
							$final .= $tipo.pg_result($result, $i, pg_field_name($result, $j)).$tipo_final;
						}
					}
					$final .= "</field>";
				}
				$final .= "</recordset>";
				break;
		}
		$final .= "</data></wddxPacket>";
		return $final;
	}


	function getXML($result) {
		switch($this->dbtype) {
			case "oracle":
				$final = "";
				$nColunas = oci_num_fields($result);
				$array = $this->getArray($result);
				$nLinhas = count($array);
				$final .= "<recordset rowCount='$nLinhas' fieldNames='";
				for($j=1;$j<=$nColunas;$j++) {
					if($j != 1) {
						$final .= ",";
					}
					$final .= strtoupper(oci_field_name($result,$j));
				}
				$final .= "' type='php.sql.QueryTable'>\n";
				for($i=0;$i<$nLinhas;$i++) {
					$final .= "  <row>\n";
					for($j=1;$j<=$nColunas;$j++) {
						$final .= "    <field name='".strtoupper(oci_field_name($result,$j))."'>";
						$final .= $tipo.xmlentities($array[$i][oci_field_name($result, $j)]);
						$final .= "</field>\n";
					}  
					$final .= "  </row>\n";
				}
				$final .= "</recordset>";
				break;
			case "postgresql":
				$final = "";
				$nColunas = pg_num_fields($result);
				$nLinhas = pg_num_rows($result);
				$final .= "<recordset rowCount='$nLinhas' fieldNames='";
				for($j=0;$j<$nColunas;$j++) {
					if($j != 0) {
						$final .= ",";
					}
					$final .= strtoupper(pg_field_name($result,$j));
				}
				$final .= "' type='php.sql.QueryTable'>";
				for($i=0;$i<$nLinhas;$i++) {
					$final .= "<row>";
					for($j=0;$j<$nColunas;$j++) {
						$final .= "<field name='".strtoupper(pg_field_name($result,$j))."'>";
						$final .= pg_result($result, $i, pg_field_name($result, $j));
						$final .= "</field>";
					}
					$final .= "</row>";
				}
				$final .= "</recordset>";
				break;
		}
		return $final;
	}
	
	function getResult($query,$resulttype='array',$params=array()) {
		switch($this->dbtype) {
			case "oracle":
				if(!$this->connected) {
					die("No conectado!");
				}
				$stmt = oci_parse($this->conexao, $query);
				if(oci_execute($stmt,OCI_DEFAULT)) {
					switch($resulttype) {
						case "array":
							$ar = $this->getArray($stmt);
							break;
						case "wddx":
							$ar = $this->getWDDX($stmt);
							break;
						case "xml":
							$ar = $this->getXML($stmt);
							break;
					}
				} else {
					$_SESSION['last_error'] = oci_error($stmt);
					throw new SystemException($_SESSION['last_error'],$query);
				}
				break;
			case "postgresql":
			default:
				if(count($params)) {
					$status = ($stmt = pg_query_params($this->conexao, $query,$params));
				} else {
					$status = ($stmt = pg_query($this->conexao, $query));
				}
				if(!$status){
					$_SESSION['last_error'] = $this->getErrors();
					throw new SystemException($_SESSION['last_error']);
				} else {
					switch($resulttype) {
						case "array":
							$ar = $this->getArray($stmt);
							break;
						case "wddx":
							$ar = $this->getWDDX($stmt);
							break;
					}
				}
				break;			
		}
		return $ar;
	}
	function getArguments(&$arguments,$result) {
		foreach($result[0] as $key => $value) {
			$arguments[preg_replace('/^p_/','',strtolower($key))] = $value;
		}
	}
	function getResultXML($query) {
		if($result = pg_query($this->conexao, $query))
			$ar = $this->getXML($result);
		else {
			$_SESSION['last_error'] = $this->getErrors();
			throw new SystemException($_SESSION['last_error'],$query);
		}
		return $ar;
		
	}
	function toWddx($array,$header=true) {
		$final = '';
		if($header) 
			$final = "<wddxPacket version='1.0'><header/><data>";
		$final .= "<struct>";
		foreach($array as $field => $value) {
			$final .= "<var name='".$field."'>";
			if(is_array($value)) {
				$final .= $this->toWddx($value,false);
			} else {
				$final .= "<string>".xmlentities($value)."</string>";
			}
			$final .= "</var>";
		}
		$final .= "</struct>";
		if($header) 
			$final .= "</data></wddxPacket>";	
		return $final;
	}
	function start() {
		if($this->connection['STARTED_TRANSACTION']) {
			$backtrace = debug_backtrace();
			throw new SystemException(array(message => "J existe uma transao iniciada para este procedimento. (".$backtrace[0]['file'].':'.$backtrace[0]['line'].")"));
		}
		$this->connection['STARTED_TRANSACTION'] = true;
		switch($this->dbtype) {
			case "oracle":
				// No precisa iniciar as transacoes
				break;
			case "postgresql":
				pg_query($this->conexao,"start transaction");
				break;
		}
	}
	function commit() {
		if(!$this->connection['STARTED_TRANSACTION']) {
			$backtrace = debug_backtrace();
			throw new SystemException(array(message => "Tentativa de efetuar o COMMIT em uma transao no aberta. Verifique se nenhuma funo interna est sem receber o parametro no_commit. (".$backtrace[0]['file'].':'.$backtrace[0]['line'].")"));
		}
		switch($this->dbtype) {
			case "oracle":
				if(!oci_commit($this->conexao)) {
					$_SESSION['last_error'] = oci_error($this->conexao);
					return false;
					throw new SystemException($_SESSION['last_error']);
				}
				$this->connection['STARTED_TRANSACTION'] = false;
				return true;
				break;
			case "postgresql":
				if(!pg_query($this->conexao,"commit")) {
					$_SESSION['last_error'] = $this->getErrors();
					throw new SystemException($_SESSION['last_error']);
				}
				$this->connection['STARTED_TRANSACTION'] = false;
				return true;
				break;
		}
	}
	function rollback() {
		if(!$this->connection['STARTED_TRANSACTION']) {
			$backtrace = debug_backtrace();
			throw new SystemException(array(message => "Tentativa de efetuar o ROLLBACK em uma transao no aberta. Verifique se nenhuma funo interna est sem receber o parametro no_commit. (".$backtrace[0]['file'].':'.$backtrace[0]['line'].")"));
		}
		switch($this->dbtype) {
			case "oracle":
				if(!oci_rollback($this->conexao)) {
					$_SESSION['last_error'] = $this->getErrors();
					throw new SystemException($_SESSION['last_error']);
				}
				$this->connection['STARTED_TRANSACTION'] = false;
				break;
			case "postgresql":
				if(!pg_query($this->conexao,"rollback")) {
					$_SESSION['last_error'] = $this->getErrors();
					throw new SystemException($_SESSION['last_error']);
				}
				$this->connection['STARTED_TRANSACTION'] = false;
				break;
		}
	}
	
	function getErrors() {
		switch($this->dbtype) {
			case "oracle":
				$erro = oci_error();
				return $erro;
				break;
			case "postgresql":
				$erro['message'] = pg_last_error();
				return $erro;
				break;
		}
	}
}

class SystemException extends Exception {
	public $catch, $query;
	public function __construct($catch,$query="teste") {
		$this->catch = $catch;
		$this->query = $query;
		parent::__construct($catch['message'].chr(13).chr(10).$query,0);
	}
	public function __toString() {
		return strlen(trim($this->catch['message']))?$this->catch['message'].' SQL:'.$this->query:'No foi possvel identificar o erro';
	}	
	public function getCatch() {
		return $this->catch;
	}
}

class SimpleXMLElementExtended extends SimpleXMLElement{
    
    public function getAttribute($name){
        foreach($this->attributes() as $key=>$val){
            if($key == $name){
                return (string)$val;
            }// end if
        }// end foreach
    }// end function getAttribute
    
    public function getAttributeNames(){
        $cnt = 0;
        $arrTemp = array();
        foreach($this->attributes() as $a => $b) { 
            $arrTemp[$cnt] = (string)$a;
            $cnt++;
        }// end foreach
        return (array)$arrTemp;
    }// end function getAttributeNames
    
    public function getChildrenCount(){
        $cnt = 0;
        foreach($this->children() as $node){
            $cnt++;
        }// end foreach
        return (int)$cnt;
    }// end function getChildrenCount
    
    public function getAttributeCount(){
        $cnt = 0;
        foreach($this->attributes() as $key=>$val){
            $cnt++;
        }// end foreach
        return (int)$cnt;
    }// end function getAttributeCount
    
    public function getAttributesArray($names){
        $len = count($names);
        $arrTemp = array();
        for($i = 0; $i < $len; $i++){
            $arrTemp[$names[$i]] = $this->getAttribute((string)$names[$i]);
        }// end for
        return (array)$arrTemp;
    }// end function getAttributesArray
    
}

// Funo para a criao dos objetos de componentes
function createObject($url,&$conexao="null") {
	// Levanta as variaveis globais atuais
	foreach($GLOBALS as $key => $value) {
		$vars[$key] = true;
	}

	global $createdObject,$conexao_banco,$variaveis_globais;

	if($conexao == "null")
		$conexao_banco =& $_SESSION['conexao'];
	else
		$conexao_banco =& $conexao;
	include($_SERVER['DOCUMENT_ROOT']."/".str_replace(".","/",$url).".php");
	if($conexao == "null")
		$_SESSION['conexao'] = &$conexao_banco;
	else
		$conexao = &$conexao_banco;
		
	// Insere as variaveis globais na lista de variaveis protegidas
	foreach($GLOBALS as $key => $value) {
		if(!isset($vars[$key])) {
//		   print("<!-- Adicionando a Variavel: ".$key." -->\n");
		   $variaveis_globais[$key] = true;
		}
	}

	return $createdObject;
}


if(function_exists('oci_connect') && $_VARS['dsn'] != '') {
	$_SESSION['dsn'] = $_VARS['dsn'];
	$_SESSION['usuario'] = $_VARS['usuario'];
	$_SESSION['senha'] = $_VARS['senha'];
	$_SESSION['conexao'] = connect($_VARS['dsn'],$_VARS['usuario'],$_VARS['senha']);
} elseif(function_exists('oci_connect') && $_SESSION['dsn'] != '') {
	$_SESSION['conexao'] = connect($_SESSION['dsn'],$_SESSION['usuario'],$_SESSION['senha']);
}
//include_once($_SERVER['DOCUMENT_ROOT']."/_class/classes/lista.php");
?>
