<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ImagemObj;
if(!$ImagemObj) {
	class ImagemMan extends QueryCom {
		/**
		 * Efetua o upload do arquivo
		 */
		function upload_arquivo($arguments) {
			if(!strlen(trim($arguments['source'])))
				return "";
			if(!strlen(trim($arguments['destination'])))
				return "";
			if(!strlen(trim($arguments['quality'])))
				$arguments['qualidade'] = 100;
			if(file_exists($arguments['source'])) {
				// Separa o diretorio do nome de arquivo
				$folders = explode("/",$arguments['destination']);
				$arquivo = array_pop($folders);
				$diretorio_destino = implode("/",$folders);			
				
				// Captura a extenso do arquivo
				$folderss = array_reverse(explode("/",$arguments['source']));
				$arquivo = $folderss[0];
				$parts = explode(".",$arquivo);
				$extensao = strtolower(array_pop($parts));
				$nome_arquivo = implode('/',$parts);
				
				if($arguments['filetype'] == "image")
					$extensao_destino = 'jpg';
				else
					$extensao_destino = $extensao;

				// Cria o Diretorio de Destino, caso ainda nao exista
				@mkdir($diretorio_destino,0775,true);
				
				// Cria um nome de arquivo unico
				$count = 0;
				while(file_exists($diretorio_destino.'/'.$extensao."_".$nome_arquivo."_".$count.".".$extensao_destino)) {
					$count++;
				}
				$arquivo_destino = $diretorio_destino.'/'.$extensao."_".$nome_arquivo."_".$count.".".$extensao_destino;
				
				// Efetua a copia do arquivo do local temporario para o definitivo
				if($arguments['filetype'] == "image") {
					// Faz a conversao da imagem
					$source = imagecreatefromstring(file_get_contents($arguments['source']));
					list($width, $height) = getimagesize($arguments['source']);
					$thumb = imagecreatetruecolor($width, $height);
					imagecopyresampled($thumb, $source, 0, 0, 0, 0, $width, $height, $width, $height);
					imagejpeg($thumb, $arquivo_destino, $arguments['qualidade']);					
				} else {
					// Efetua a copia direta do arquivo
					copy($arguments['source'],$arquivo_destino);
				}
				
				return $arquivo_destino;
			}
		}
		
		/* Chama Redimensionamento correto */
		//function redimensiona_imagem($arguments) {
		function redimensiona($arguments) {
			//Monta os parametro
			$parametros ='ajuste=redimensionar';
			foreach($arguments as $campo => $valor) {
				$parametros .= '&'.$campo.'='.$valor;
			}

			//monta o caminho do arquivo que imprime o caminho da imagem redimensionada			
			$path = 'http://'.$_SERVER['HTTP_HOST']."/_class/funcoes/resizer.php?".$parametros;			
			//new dBug($path);
			//joga o conteudo da pagina na variavel
			$url_imagem = file_get_contents($path);	
//			new dBug($url_imagem);
			return $url_imagem;
		}
		
		//function corta_imagem($arguments){
		function recortar($arguments){
			//Monta os parametros
			$parametros ='ajuste=cortar';
			foreach($arguments as $campo => $valor) {
				$parametros .= '&'.$campo.'='.$valor;
			}

			//monta o caminho do arquivo que imprime o caminho da imagem redimensionada
			$path = 'http://'.$_SERVER['HTTP_HOST']."/_class/funcoes/resizer.php?".$parametros;
			//joga o conteudo da pagina na variavel
			$url_imagem = file_get_contents($path);

			return $url_imagem;
			
		}
		 
		
		
		
		/**
		 * Redimensiona uma imagem (adaptado, recebe foto_id ou url)
		 */
		//function redimensionar($arguments) {
		function redimensiona_imagem($arguments) {
			// Cria a URL da Foto a ser salva e testa se o arquivo original existe
			if(strlen(trim($arguments[foto_id]))) {
				$extensao = 'jpg';
				$url = '/temp/foto'.$arguments[foto_id].".".$extensao;
			} else if(strlen(trim($arguments[url]))) {
				$fp = fopen($_SERVER['DOCUMENT_ROOT']."/temp/redimensiona_imagem.log","a");
				$ar = debug_backtrace();
				fwrite($fp,$ar[0]['file'].":".$ar[0]['line']."\n");
				fclose($fp);
				
				$url = $arguments[url];
				$extensao = array_reverse(explode(".",$url));
				$extensao = $extensao[0];
				// testa se o arquivo existe
				if(!file_exists($_SERVER['DOCUMENT_ROOT'].$arguments[url]) || filesize($_SERVER['DOCUMENT_ROOT'].$arguments[url]) == 0)
					return "";
			} else {
				return "";
			}
			
			// Monta a URL do arquivo de cache
			if(strlen(trim($arguments[width]))) {
				$url = str_replace(".".$extensao,"_h".$arguments[width].".jpg",$url);
			} elseif(strlen(trim($arguments[height]))) {
				$url = str_replace('.'.$extensao,"_v".$arguments[height].".jpg",$url);
			} elseif(strlen(trim($arguments[maxwidth])) || strlen(trim($arguments[maxheight]))) {
				$url = str_replace('.'.$extensao,"_mh".$arguments[maxwidth]."_mv".$arguments[maxheight].".jpg",$url);
			} else {
				return $url;
			}
			
			$name = array_reverse(explode('/',$url));
			$url = '/temp/foto'.$name[0];

			if($arguments['forca_atualizacao'] == 1){
				$count = 1;
				$url = '/temp/foto_fa_'.$count.$name[0];
				while(file_exists($_SERVER['DOCUMENT_ROOT'].$url)){
					$count++;
					$url = '/temp/foto'.$count.$name[0];
				}
			}

			// Busca o arquivo original
			if(file_exists($_SERVER['DOCUMENT_ROOT'].$url) && filesize($_SERVER['DOCUMENT_ROOT'].$url) > 0 && $arguments['forca_atualizacao'] != 1) {
				return $url;
			} else {
				if(strlen(trim($arguments[foto_id]))) {
					// Consulta a foto remota
					$connFoto = CreateObject("portal._class.consulta.site");
					$qrFoto = $connFoto->get_foto_conteudo(array(foto_id => $arguments[foto_id]));
					if(count($qrFoto) == 1) {
						$source = imagecreatefromstring(base64_decode($qrFoto[0]['CONTEUDO']));
					} else {
						return "";
					}
				} else if(strlen(trim($arguments[url]))) {
					$source = imagecreatefromstring(file_get_contents($_SERVER['DOCUMENT_ROOT'].$arguments[url]));
				} else {
					return "";
				}
			}
			
			// Busca as dimensoes do arquivo original
			$width = imagesx($source);
			$height = imagesy($source);
			$quality = !strlen(trim($arguments['quality']))?100:$arguments['quality'];
			$quality = 100;

			// Efetua o redimensionamento			
			if(strlen(trim($arguments[width]))) {
				// cria o nome do arquivo redimensionado
				$arguments[height] = ($arguments[width]/$width) * $height;
				$thumb = imagecreatetruecolor($arguments[width], $arguments[height]);
				imagecopyresampled($thumb, $source, 0, 0, 0, 0, $arguments[width], $arguments[height], $width, $height);
				// Cria a imagem com 100% de qualidade
				imagejpeg($thumb, $_SERVER['DOCUMENT_ROOT'].$url, $quality); 
				return $url;
			} elseif(strlen(trim($arguments[height]))) {
				$arguments[width] = ($arguments[height]/$height) * $width;
				$thumb = imagecreatetruecolor($arguments[width], $arguments[height]);
				imagecopyresampled($thumb, $source, 0, 0, 0, 0, $arguments[width], $arguments[height], $width, $height);
				imagejpeg($thumb, $_SERVER['DOCUMENT_ROOT'].$url, $quality); 
				return $url;
			} elseif(strlen(trim($arguments[maxwidth])) || strlen(trim($arguments[maxheight]))) {
				if(strlen(trim($arguments[maxwidth]))) {
					if($width > $arguments[maxwidth] || (strlen(trim($arguments[maxheight])) && $height > $arguments[maxheight])) {
						$reducao = $arguments[maxwidth]/$width;
						if(strlen(trim($arguments[maxheight])) && ($height*$reducao > $arguments[maxheight])) {
							$reducao = $arguments[maxheight]/$height;
							$arguments[maxwidth] = $width*$reducao;
						} else {
							$arguments[maxheight] = $height*$reducao;
						}
					} else {
						$arguments[maxwidth] = $width;
						$arguments[maxheight] = $height;
					}
					$thumb = imagecreatetruecolor($arguments[maxwidth], $arguments[maxheight]);
					imagecopyresampled($thumb, $source, 0, 0, 0, 0, $arguments[maxwidth], $arguments[maxheight], $width, $height);
					imagejpeg($thumb, $_SERVER['DOCUMENT_ROOT'].$url, $quality); 
					return $url;
				} else if(strlen(trim($arguments[maxheight]))) {
					if($height > $arguments[maxheight]) {
						$reducao = $arguments[maxheight]/$height;
						$arguments[maxwidth] = $width*$reducao;
					} else {
						$arguments[maxwidth] = $width;
						$arguments[maxheight] = $height;
					}
					$thumb = imagecreatetruecolor($arguments[maxwidth], $arguments[maxheight]);
					imagecopyresampled($thumb, $source, 0, 0, 0, 0, $arguments[maxwidth], $arguments[maxheight], $width, $height);
					imagejpeg($thumb, $_SERVER['DOCUMENT_ROOT'].$url, $quality); 
					return $url;
				}
			} else {
				return $url;
			}
		}
		
		/* Corta uma imagem */
		//function recortar($arguments=array()) {
		function corta_imagem($arguments=array()) {
			// width			- Largura da area de corte
			// height			- Altura da area de corte
			// top			 	- distancia da borda superior para o corte *
			// left				- distancia da borda esquerda do ponto de corte *

			// ou

			// width			- Largura da area de corte
			// height			- Altura da area de corte
			// resample			- Indica que a imagem ser redimensionada para ajustar-se ao tamanho (No funciona junto com o top ou left)
			// valign			- Alinhamento vertical do corte (Default: top) top | middle | bottom *
			// align			- Alinhamento Horizontal do Corte (Default: center) left | center | right *
			
			// outputtype		- Tipo de Arquivo de Saida (Default: jpeg) *
			
			// * Funcionalidades ainda no disponiveis
			
			// Ajusta os parametros default
			if(!strlen(trim($arguments['align'])))
				$arguments['align'] = 'center';
			else
				$arguments['align'] = strtolower($arguments['align']);

			if(!strlen(trim($arguments['valign'])))
				$arguments['valign'] = 'top';
			else
				$arguments['valign'] = strtolower($arguments['valign']);

			if(!strlen(trim($arguments['top'])))
				$arguments['top'] = 0;

			if(!strlen(trim($arguments['left'])))
				$arguments['left'] = 0;

			if(!strlen(trim($arguments['quality'])))
				$arguments['quality'] = 100;
			
			// Cria a URL da Foto a ser salva e testa se o arquivo original existe
			if(strlen(trim($arguments[foto_id]))) {
				$extensao = 'jpg';
				$url = '/temp/foto'.$arguments[foto_id].".".$extensao;
			} else if(strlen(trim($arguments[url]))) {
				$url = $arguments[url];
				$extensao = array_reverse(explode(".",$url));
				$extensao = $extensao[0];
				// testa se o arquivo existe
				if(!file_exists($_SERVER['DOCUMENT_ROOT'].$arguments[url]) || filesize($_SERVER['DOCUMENT_ROOT'].$arguments[url]) == 0)
					return "";
			} else {
				return "";
			}
			// Monta o caminho da foto
			if(strlen(trim($arguments['width'])) && strlen(trim($arguments['height'])) && strlen(trim($arguments['resample']))) {
				$url = str_replace('.'.$extensao,"_r1_q".$arguments['quality']."_va".substr($arguments['valign'],0,1)."_a".substr($arguments['align'],0,1)."_ch".$arguments['width']."_cv".$arguments['height'].".jpg",$url);
			} else {
				$url = str_replace('.'.$extensao,"_c1_q".$arguments['quality']."_t".$arguments['top']."_l".$arguments['left']."_ch".$arguments['width']."_cv".$arguments['height'].".jpg",$url);
			}	
			
			// Verifica se o cache existe e possui tamanho
			if(file_exists($_SERVER['DOCUMENT_ROOT'].$url) && filesize($_SERVER['DOCUMENT_ROOT'].$url) > 0) {
				return $url;
			}
			
			// Busca o arquivo original
			if(strlen(trim($arguments[foto_id]))) {
				// Consulta a foto remota
				$connFoto = CreateObject("portal._class.consulta.site");
				$qrFoto = $connFoto->get_foto_conteudo(array(foto_id => $arguments[foto_id]));
				if(count($qrFoto) == 1) {
					$source = imagecreatefromstring(base64_decode($qrFoto[0]['CONTEUDO']));
				} else {
					return "";
				}
			} else if(strlen(trim($arguments[url]))) {
				$source = imagecreatefromstring(file_get_contents($_SERVER['DOCUMENT_ROOT'].$arguments[url]));
			} else {
				return "";
			}
			
			// Busca as dimensoes do arquivo original
			$width = imagesx($source);
			$height = imagesy($source);
			
			
			if(strlen(trim($arguments['width'])) && strlen(trim($arguments['height'])) && strlen(trim($arguments['resample']))) {
				// Calcula a proporo da foto original
				$proporig = $width/$height;
				//Calcula a proporo da area de corte
				$propcorte = $arguments['width']/$arguments['height'];
				$destw = $arguments['width'];
				$desth = $arguments['height'];
				// Se a proporo de corte for maior que a proporo original, basea-se na largura
				if($proporig < $propcorte) {
					// Calcula o retangulo de corte
					$cutx = 0;
					$cutw = $width;
					$cuth = $width/$propcorte;
					switch($arguments['valign']) {
						case 'middle':
							$cuty = ($height-$cuth)/2;
							break;
						case 'bottom':
							$cuty = ($height-$cuth);
							break;
						case 'top':
						default:
							$cuty = 0;
							break;
					}
							
				} else {
					// Calcula o retangulo de corte
					$cuty = 0;
					$cuth = $height;
					$cutw = $height*$propcorte;
					switch($arguments['align']) {
						default:
						case 'center':
							$cutx = ($width-$cutw)/2;
							break;
						case 'right':
							$cutx = ($width-$cutw);
							break;
						case 'left':
							$cutx = 0;
							break;
					}
				}
			} else {
				$cutx = $arguments['left'];
				$cuty = $arguments['top'];

				$destw = $width-$cutx;
				$desth = $height-$cuty;

				$cutw = $destw;
				$cuth = $desth;
			}
			
			// Cria uma imagem em branco (Na verdade preto) para receber o resultado
			$thumb = imagecreatetruecolor($arguments['width'], $arguments['height']);
			$backgroundcolor = imagecolorallocate($thumb,255,255,255);
			imagefill($thumb,0,0,$backgroundcolor);
			// Efetua o corte
			imagecopyresampled($thumb, $source, 0, 0, $cutx, $cuty, $destw, $desth, $cutw, $cuth);
			imagejpeg($thumb, $_SERVER['DOCUMENT_ROOT'].$url, $arguments['quality']); 
			return $url;
		}
		
		function marca_dagua($arguments=array()) {
			
			$barras = explode("/",$arguments['imagem']);

			$arquivo = explode(".",$barras[count($barras)-1]);
			
			$nome = $arquivo[0];
			$extensao = $arquivo[1];
			
			//$path = "/";
			for($i=0; $i < count($barras)-1; $i++){
				$path .= $barras[$i]."/";
			}

			$url = $path.$nome."_md".".".$extensao;

			//se nao tiver gerado ainda a imagem com marca d'agua, entao gerar			
			if( !file_exists($_SERVER['DOCUMENT_ROOT'].$url) ){
			
				#variavel que recebe a url/caminho da imagem
				$filename = $_SERVER['DOCUMENT_ROOT'].$arguments['imagem'];
				
				#dados da mascara [caminho do arquivo que serve de mascara]
				$marca =  $_SERVER['DOCUMENT_ROOT'].$arguments['marca'];
				$imagem_marca =   ImageCreateFromGif($marca);
				$pontoX1 =   ImagesX($imagem_marca);
				$pontoY1 =   ImagesY($imagem_marca);
				
				#recupera as dimensoes da imagem
				list($width, $height) = getimagesize($filename);
				
				
				
				#definindo tamanho padro para as fotos
				$new_width = $width;
				$new_height = $height;
				
				#redesenhando a imagem
				$image_p = imagecreatetruecolor($new_width, $new_height);
				$image = imagecreatefromjpeg($filename);
				imagecopyresampled($image_p, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
				
				#Habilitando a opcao abaixo ir criar a mascara com a imagem marca d'agua
				ImageCopyMerge($image_p, $imagem_marca, $arguments['left'], $arguments['top'], 0, 0, $pontoX1, $pontoY1, $arguments['transparencia']);
				
				imagejpeg($image_p, $_SERVER['DOCUMENT_ROOT'].$url, 100);
			
			}
			
			return $url;
		
		}
		
		
	}
	global $conexao_banco;
	$ImagemObj = new ImagemMan($conexao_banco);
}

global $createdObject;
$createdObject = $ImagemObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>