<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $SSSUConsultaObj;
if(!$SSSUConsultaObj) {
	class SSSUConsulta extends QueryCom {
		function get_vdisk($arguments) {
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			$comando .= ' "ls vdisk "';
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			if($retorno == 0) {
				while(strpos($output[0],"Vdisks available") === false) {
					array_splice($output,0,1);
				}
				array_splice($output,0,1);
			}
			return implode(",",$output);
		}

		function get_lun_hosts($arguments) {
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			$comando .= ' "ls lun "';
//			$comando .= ' 2>&1';
//			print($comando);
			exec($comando,$output,$retorno);
//			if(strtolower(substr($output[0],0,strlen('svn: warning:'))) == strtolower('svn: warning:'))
//				array_splice($output,0,1);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				while(strpos($output[0],"LUNs available") === false) {
					array_splice($output,0,1);
				}
				array_splice($output,0,1);
				$ret = array();
				for($i=0;$i<count($output);$i++) {
					$parts = explode('\\',$output[$i]);
					if(array_pop($parts) == $arguments[lun]) {
						array_push($ret,array_pop($parts));
					}
				}
			}
			return $ret;
		}

		function get_vdisk_details($arguments) {
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			$comando .= ' \'ls vdisk "'.str_replace('\\\\','\\',$arguments[vdisk]).'" xml \' ';
//			$comando .= ' 2>&1';
//			print($comando);
			exec($comando,$output,$retorno);
//			if(strtolower(substr($output[0],0,strlen('svn: warning:'))) == strtolower('svn: warning:'))
//				array_splice($output,0,1);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				while(strpos($output[0]," information:") === false) {
					array_splice($output,0,1);
				}
				array_splice($output,0,1);
				$ret = $output;
			}
			return implode("\n",$ret);
		}
		
		function get_lun_details($arguments) {
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			$comando .= ' \'ls lun "\\Hosts\\'.$arguments[host].'\\'.$arguments[lun].'" xml \' ';
//			$comando .= ' 2>&1';
//			print($comando);
			exec($comando,$output,$retorno);
//			if(strtolower(substr($output[0],0,strlen('svn: warning:'))) == strtolower('svn: warning:'))
//				array_splice($output,0,1);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				while(strpos($output[0]," information:") === false) {
					array_splice($output,0,1);
				}
				array_splice($output,0,1);
				$ret = $output;
			}
			return implode("\n",$ret);
		}

		function del_lun($arguments) {
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			// Monta o array com os hosts
			$hosts = explode(',',$arguments[hosts]);

			// Exclui as luns que existirem
			$hosts_lun = $this->get_lun_hosts(array(
											manager		=> $arguments[manager],
											usuario		=> $arguments[usuario],
											senha		=> $arguments[senha],
											'system'	=> $arguments['system'],
											lun			=> $arguments[lun]
											));
			for($i=0;$i<count($hosts_lun);$i++) {
				if(!strlen(trim($arguments[hosts])) || array_search($hosts_lun[$i],$hosts) !== false) 
					$comando .= ' \'delete lun \\Hosts\\'.$hosts_lun[$i].'\\'.$arguments[lun].'\' ';
			}
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}
		
		function add_lun($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);

			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			// Monta o array com os hosts
			$hosts = explode(',',$arguments[hosts]);

			// Verifica se alguma das luns j es ocupada
			$hosts_lun = $this->get_lun_hosts(array(
											manager		=> $arguments[manager],
											usuario		=> $arguments[usuario],
											senha		=> $arguments[senha],
											'system'	=> $arguments['system'],
											lun			=> $arguments[lun]
											));
			for($i=0;$i<count($hosts);$i++) {
				if(array_search($hosts[$i],$hosts_lun) === false) {
					$comando .= ' \'add lun '.$arguments[lun].' vdisk="\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" host="\\Hosts\\'.$hosts[$i].'"\' ';
				}
			}
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}
		
		function move_vdisk($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);
			
			$destination = str_replace('\\\\','\\',$arguments[destination]);

			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			$comando .=  ' \'move vdisk "\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" "\\Virtual Disks\\'.$destination.'" \' ';
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}
		
		function rename_vdisk($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);
			
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			$comando .= ' \'set vdisk "\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" name="'.$arguments[newname].'"\' ';
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}

		function writecache_vdisk($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);
			
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			$comando .= ' \'set vdisk "\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" writecache='.($arguments[writethrough]==1?'writethrough':'writeback').' \' ';
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}

		function copy_vdisk($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);

			$parts = explode("\\",$arguments[svdisk]);
			$svdiskname = array_pop($parts);
			$svdiskfolder = implode("\\",$parts);
			if(strlen($svdiskfolder))
				$svdiskfolder .= '\\';
			$svdiskfolder = str_replace('\\\\','\\',$svdiskfolder);
			
			
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			$comando .= ' \'add copy "'.$vdiskname.'" vdisk="\\Virtual Disks\\'.$svdiskfolder.$svdiskname.'" redundancy=vraid'.$arguments[raid].' disk_group="'.$arguments[disk_group].'" \' ';
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}
		
		function comment_vdisk($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);
			
			
			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			
			$comando .= ' \'set vdisk "\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" comment="'.$arguments[comment].'"\' ';
			
			exec($comando,$output,$retorno);
			// Valida a execuo do comando
			$ret = $output;
			if($retorno == 0) {
				return 0;
			}
			return implode("\n",$ret);
		}

		function sincronizar_disco($arguments) {
			// Explode o nome do disco
			$parts = explode("\\",$arguments[vdisk]);
			$vdiskname = array_pop($parts);
			$vdiskfolder = implode("\\",$parts);
			if(strlen($vdiskfolder))
				$vdiskfolder .= '\\';
			$vdiskfolder = str_replace('\\\\','\\',$vdiskfolder);

			$parts = explode("\\",$arguments[svdisk]);
			$svdiskname = array_pop($parts);
			$svdiskfolder = implode("\\",$parts);
			if(strlen($svdiskfolder))
				$svdiskfolder .= '\\';
			$svdiskfolder = str_replace('\\\\','\\',$svdiskfolder);

			$comando = '/usr/local/bin/sssu ';
			$comando .= ' "set options on_error=exit_on_error noretries" ';
			$comando .= ' "select manager '.$arguments[manager].' user='.$arguments[usuario].' pass='.$arguments[senha].'" ';
			$comando .= ' "select system '.$arguments['system'].'" ';
			// Monta o array com os hosts
			$hosts = explode(',',$arguments[hosts]);

			// Exclui as luns que existirem
			$hosts_lun = $this->get_lun_hosts(array(
											manager		=> $arguments[manager],
											usuario		=> $arguments[usuario],
											senha		=> $arguments[senha],
											'system'	=> $arguments['system'],
											lun			=> $arguments[lun]
											));
			for($i=0;$i<count($hosts_lun);$i++) {
				$comando .= ' \'delete lun \\Hosts\\'.$hosts_lun[$i].'\\'.$arguments[lun].'\' ';
			}
			
			// Move o disco atual para o pool de excluso
			$comando .=  ' \'move vdisk "\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" "\\Virtual Disks\\Pool Exclusao" \' ';
			
			// Gera o nome para o pool
			$poolname .= substr($vdiskname,0,18).date('ymd').date('His');
			// Renomeia o disco movido dentro do pool (Evitar duplicaes)
			$comando .= ' \'set vdisk "\\Virtual Disks\\Pool Exclusao\\'.$vdiskname.'" name="'.$poolname.'"\' ';
			
			// Muda o disco para writethrough (Necessario para a clonagem)
			$comando .= ' \'set vdisk "\\Virtual Disks\\'.$svdiskfolder.$svdiskname.'" writecache=writethrough\' ';
			
			// Efetua a clonagem do disco (no aguarda a concluso)
			$comando .= ' \'add copy "'.$vdiskname.'" vdisk="\\Virtual Disks\\'.$svdiskfolder.$svdiskname.'" redundancy=vraid0 disk_group="FATA Disk Group 1" \' ';
			
			// Se necessrio, move o disco gerado para o diretorio
			if($vdiskfolder != $svdiskfolder)
				$comando .=  ' \'move vdisk "\\Virtual Disks\\'.$svdiskfolder.$vdiskname.'" "\\Virtual Disks\\'.$vdiskfolder.'" \' ';
			
			// Apresenta o disco novo para os hosts
			for($i=0;$i<count($hosts);$i++) {
				$comando .= ' \'add lun '.$arguments[lun].' vdisk="\\Virtual Disks\\'.$vdiskfolder.$vdiskname.'" host="\\Hosts\\'.$hosts[$i].'"\' ';
			}

			exec($comando,$output,$retorno);
			
			print(implode('<br>',$output));
//			if(strtolower(substr($output[0],0,strlen('svn: warning:'))) == strtolower('svn: warning:'))
//				array_splice($output,0,1);
			// Valida a execuo do comando
			return $retorno;
		}

	}
	global $conexao_banco;
	$SSSUConsultaObj = new SSSUConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $SSSUConsultaObj;


if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>