<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $PrevisaoTempoComObj;
if(!$PrevisaoTempoComObj) {
	class PrevisaoTempoCom extends QueryCom {
		/**
		 * Busca a previso para o municipio na data
		 */
		function get_previsao_municipio ($arguments=array()) {
								
			if(strlen(trim($arguments[data]))) {
				$regs = 1;
			} else {
				$regs = 4;
			}
			if(strlen(trim($arguments['num_dias'])))
				$regs = $arguments['num_dias'];
			// Busca se existem dados na base de dados
			$qrPrevisao = $this->get_previsao_municipio_interna($arguments);
			
			if(count($qrPrevisao) < $regs-1 && !strlen(trim($arguments[data]))) {
				// Caso nao existam, busca os dados do site do INPE
				$qrPrevisaoDados = $this->get_previsao_municipio_inpe($arguments);
				// Insere na base de dados
				$conn = CreateObject("_class.manipulacao.previsao_tempo");
				for($i=0;$i<count($qrPrevisaoDados);$i++) {
					$ret = $conn->ins_previsao_municipio(array(
											municipio		=> $arguments['municipio'],
											sigla_uf		=> $arguments['uf'],
											data			=> $qrPrevisaoDados[$i]['DATA'],
											url_previsao	=> $qrPrevisaoDados[$i]['IMAGE'],
											maxima			=> $qrPrevisaoDados[$i]['MAXIMA'],
											minima			=> $qrPrevisaoDados[$i]['MINIMA']
//											no_commit		=> 1
											));
				}
				// Busca os dados novamente
				$qrPrevisao = $this->get_previsao_municipio_interna($arguments);
			}
			return $qrPrevisao;
		}
		
		/**
		 * Busca a previsao do tempo para o municipio pelo Site do INPE
		 */
		function get_previsao_municipio_inpe($arguments=array()) {
			
			$qrMunicipio = $this->get_dados_municipio($arguments);
						
			//return;
			
			if(count($qrMunicipio) == 1 && $qrMunicipio[0]['COD_INPE'] != '') {
				// Efetua a leitura da URL remota com timeout reduzido
				$timeout = 2; 
				$oldtimeout = ini_set('default_socket_timeout', $timeout); 
				//$url_acesso = "http://tempo.cptec.inpe.br/cptec/supertempo.jsp?cidade=".$qrMunicipio[0]['COD_INPE'];
				$url_acesso = "http://tempo1.cptec.inpe.br/cidades/previsao.do?parameter=tempo&id=".$qrMunicipio[0]['COD_INPE'];
				$execucao = ($handler = @fopen($url_acesso, 'r'));
				ini_set('default_socket_timeout', $oldtimeout); 
				if(!$execucao) {
					return $qrRetorno;
				}

				$conteudo_original = stream_get_contents($handler);
				fclose($handler);

				// Ajusta o conteudo para facilitar a interpretao
				$conteudo = ereg_replace("<[^>]*>","",$conteudo_original); 
				$conteudo = trim(ereg_replace(chr(10)&"|"&chr(13),"",$conteudo)); 
				$conteudo = ereg_replace("  ","",trim($conteudo));
				$conteudo = trim(ereg_replace("&nbsp;","||",$conteudo));
				$qrRetorno = array();
				$incr = 0;
				for($i=0;$i<4;$i++) {
					$qrRetorno[$i] = array();
					// Verifica se a previsao deve iniciar com o dia de hj ou de amanha
					if($i==0) {
						if(strpos($conteudo,date('d.m.Y',time()+60*60*24*$i)) === false) {
							$incr = 1;
						}
					}
					$qrRetorno[$i]['DIA'] = date('d.m.Y',time()+60*60*24*($i+$incr));
					$qrRetorno[$i]['DATA'] = date('d/m/Y',time()+60*60*24*($i+$incr));
					$qrRetorno[$i]['START'] = strpos($conteudo_original,$qrRetorno[$i]['DIA']);
					$qrRetorno[$i]['START2'] = strpos($conteudo,$qrRetorno[$i]['DIA']);
					$inicio = strpos($conteudo_original,'<img src="http://img0.cptec.inpe.br/~rgrafico/icones_principais/tempo/maior',$qrRetorno[$i]['START']);
					$fim = strpos($conteudo_original,'.gif',$inicio);
					$qrRetorno[$i]['IMAGE'] = substr($conteudo_original,$inicio+10,($fim-$inicio)-6);
					$inicio = strpos($conteudo,'NIMA',$qrRetorno[$i]['START2']);
					$fim = strpos($conteudo,"C",$inicio);
					$qrRetorno[$i]['MINIMA'] = trim((substr($conteudo,$inicio+4,$fim-($inicio+4))));
					$inicio = strpos($conteudo,"XIMA",$qrRetorno[$i]['START2']);
					$fim = strpos($conteudo,"",$inicio);
					$qrRetorno[$i]['MAXIMA'] = str_replace(">","",trim(substr($conteudo,$inicio+4,$fim-($inicio+4))));
					unset($qrRetorno[$i]['DIA']);
					unset($qrRetorno[$i]['START']);
					unset($qrRetorno[$i]['START2']);
				}
				return $qrRetorno;
			}
			return array();
		}
		
		/**
		 * Busca os dados do municipio para a busca no INPE
		 */
		function get_dados_municipio($arguments=array()) {
			$query = 
			' select t.municipio,
					 t.uf_id, 
					 cod_inpe
			    from cep.municipio t
			   where upper(kss.pkg_string.fnc_string_clean(t.municipio)) = upper(kss.pkg_string.fnc_string_clean(\''.$arguments[municipio].'\'))
			     and uf_id = upper(\''.$arguments[uf].'\')';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query);
		}

		/**
		 * Busca a previsao do tempo para o municipio nas datas
		 */
		function get_previsao_municipio_interna($arguments=array()) {
			$query = 
			'select t.municipio,
				   t.sigla_uf,
				   to_char(t.data,\'dd/mm/yyyy hh24:mi:ss\') as data,
				   t.url_previsao,
				   t.maxima,
				   t.minima,
				   p.descricao,
				   p.ordem
			  from tempo.v$previsao_tempo_municipio t		
             inner join tempo.v$previsao_tempo p
               on p.url = t.url_previsao	
			 where upper(kss.pkg_string.fnc_string_clean(t.municipio)) = upper(kss.pkg_string.fnc_string_clean(\''.$arguments[municipio].'\'))
			   and sigla_uf = upper(\''.$arguments[uf].'\') 
			   and date_update > sysdate - (1/24)*5 ';
			if(strlen(trim($arguments[data])))
				$query .= ' and data = \''.$arguments[data].'\' ';
			else
				$query .= ' and trunc(data) between trunc(sysdate) and trunc(sysdate)+4 ';
			$query .= ' order by data ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query);
		}
	}
	$PrevisaoTempoComObj = new PrevisaoTempoCom($_SESSION["conexao"]);
}

global $createdObject;
$createdObject = $PrevisaoTempoComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS)));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>