<?php
class LayoutCom extends QueryCom {
	function get_layout($arguments) {
		$query = 
		'select l.layout_id,
				l.descricao,
				to_char(l.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				l.user_insert,
				to_char(l.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				l.user_update,
				l.site
		   from site.v$layout l
		  where 1=1';
		if(strlen(trim($arguments["LAYOUT_ID"])))
			$query .= ' and l.layout_id = '.$arguments["LAYOUT_ID"];
		return $this->getResult($query);
	}

	function get_layout_estrutura($arguments) {
		$query = 
		'	select ltc.layout_coluna_id,
				   lt.layout_tabela_id,
			       tm.largura largura_tabela,
				   lt.layout_coluna_id_pai,
				   tmc.largura,
				   level,
				   tm.colunas
			  from site.v$layout_tabela lt
			 inner join site.v$tabela_modelo tm
					 on tm.tabela_id = lt.tabela_id
			 inner join site.v$layout_tabela_coluna ltc
					 on ltc.layout_tabela_id = lt.layout_tabela_id
			 inner join site.v$tabela_modelo_coluna tmc
					 on tmc.coluna_id = ltc.coluna_id			
			 where 1=1 ';
		if(strlen(trim($arguments["LAYOUT_ID"])))
			$query .= ' 
				   and layout_id = '.$arguments["LAYOUT_ID"];
		$query .= '
			 start with layout_coluna_id_pai is null
			connect by layout_coluna_id_pai = prior layout_coluna_id
			 order siblings by lt.ordem, tmc.ordem';
		return $this->getResult($query);
	}

	function get_layout_tabela_coluna($arguments) {
		$query = 
		'	select lc.layout_coluna_id,
				   lc.layout_tabela_id,
				   lc.coluna_id,
				   c.largura,
				   lc.date_insert,
				   lc.user_insert,
				   lc.date_update,
				   lc.user_update,
				   lc.site
			  from site.v$layout_tabela_coluna lc
			 inner join site.v$tabela_modelo_coluna c
			         on c.coluna_id = lc.coluna_id
			 where 1=1 ';
		if(strlen(trim($arguments["LAYOUT_COLUNA_ID"])))
			$query .= ' 
				   and lc.layout_coluna_id = '.$arguments["LAYOUT_COLUNA_ID"];
		return $this->getResult($query);
	}
	function get_tabela_modelo($arguments) {
		$query = 
		'	select tm.tabela_id,
				   tm.descricao,
				   tm.colunas,
				   tm.largura,
				   (select kss.fnc_concat_all(to_concat_expr(to_char(largura),\',\'))
				      from site.v$tabela_modelo_coluna tmc
					 where tmc.tabela_id = tm.tabela_id) medidas,
				   tm.date_insert,
				   tm.user_insert,
				   tm.date_update,
				   tm.user_update,
				   tm.site
			  from site.v$tabela_modelo tm
			 where 1=1 ';
		if(strlen(trim($arguments["LARGURA"])))
			$query .= ' 
				   and tm.largura = '.$arguments["LARGURA"];
		if($arguments["MAIS_QUE_1_COLUNA"])
			$query .= ' 
				   and tm.colunas > 1 ';
		return $this->getResult($query);
	}
}

global $createdObject;
$createdObject = new LayoutCom($_SESSION["conexao"]);
?>