<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $ErrosConsultaObj;
if(!$ErrosConsultaObj) {
	class ErrosConsulta extends QueryCom {
		/**
		 * Busca os dados do municipio para a busca no INPE
		 */
		function get_erro_categoria($arguments=array(),$resulttype='array') {
			$query = 
			' select categoria_id,
				     categoria_id_pai,
				     descricao,
					 lpad(\' \',level-1,\' \') as nivel,
				     date_insert,
				     user_insert,
				     date_update,
				     user_update,
				     site
			    from kss.v$erro_categoria
			   where 1=1 ';
			if(strlen(trim($arguments['categoria_id_pai'])))
				$query .= ' and nvl(categoria_id_pai,-1) = '.$arguments['categoria_id_pai'];
			$query .= '
	           start with categoria_id_pai is null
    	     connect by prior categoria_id = categoria_id_pai';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			switch($resulttype) {	
				case "array":
				    return $this->getResult($query);
				case "wddx":
					return $this->getResult($query,'wddx');
			}
		}
		/**
		 * Busca o Endereco pelo CEP
		 */
		function get_erro_mensagem($arguments=array(),$resulttype='array') {
			$query = '
				select m.cod_erro,
					   m.categoria_id, ';
			if($arguments['todos_idiomas'] == 1)
				$query .= '
					   ei.cod_idioma,
					   ei.mensagem,
					   ei.causa,
					   ei.acao,
					   ';
			$query .= '
					   m.descricao_parametros,
					   m.usado_em,
					   m.date_insert,
					   m.user_insert,
					   m.date_update,
					   m.user_update,
					   m.site
				  from kss.v$erro_mensagem m ';
			if($arguments['todos_idiomas'] == 1)
				$query .= '
				  left join kss.v$erro_mensagem_idioma ei
				         on ei.cod_erro = m.cod_erro ';
			$query .= '
				 where 1=1
				';
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and nvl(categoria_id,-1) = '.$arguments['categoria_id'];
			if(strlen(trim($arguments['cod_erro'])))
				$query .= ' and m.cod_erro = \''.$arguments['cod_erro'].'\'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
		
		/**
		 * Busca o Endereco pelo CEP
		 */
		function get_erro_mensagem_tree($arguments=array(),$resulttype='array') {
			$query = '
				select cod_erro,
					   categoria_id,
					   categoria_id_pai,
					   descricao,
					   tipo
				  from (select to_char(categoria_id) as cod_erro,
							   categoria_id,
							   categoria_id_pai,
							   descricao,
							   \'categoria\' as tipo
						  from kss.v$erro_categoria
						 union all
						select cod_erro,
							   null as categoria_id,
							   categoria_id as categoria_id_pai,
							   c.cod_erro as descricao,
							   \'mensagem\' as tipo
						  from kss.v$erro_mensagem c)
				 where 1=1
				';
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and nvl(categoria_id_pai,-1) = '.$arguments['categoria_id'];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
 
		/**
		 * Busca o Endereco pelo CEP
		 */
		function get_idioma($arguments=array(),$resulttype='array') {
			$query = '
				select cod_idioma,
					   descricao,
					   ordem,
					   disponivel,
					   date_insert,
					   user_insert,
					   date_update,
					   user_update,
					   site
				  from kss.v$idioma m
				 where 1=1
				';
			if(strlen(trim($arguments['cod_erro'])))
				$query .= ' and m.cod_erro = \''.$arguments['cod_erro'].'\'';
			$query .= ' order by ordem ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
}
	$ErrosConsultaObj = new ErrosConsulta($_SESSION["conexao"]);
}

global $createdObject;
$createdObject = $ErrosConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>