<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $ChatComObj;
if(!$ChatComObj) {
	class ChatCom extends QueryCom {
		/**
		 * Busca Recursos
		 */
		function get_recursos($arguments=array(),$resulttype='array') {
			$query = 
			' select r.recurso_id,
					 r.nome,
					 r.nome_completo,
					 r.cliente_id
			    from kmm.v$recurso r
			   where 1=1 ';
			if(strlen(trim($arguments[tecnico])))
				$query .= ' and r.tecnico = '.$arguments[tecnico];
			if(strlen(trim($arguments[recurso_id])))
				$query .= ' and r.recurso_id = '.$arguments[recurso_id];
			$query .= ' order by r.nome ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			switch($resulttype) {	
				case "array":
				    return $this->getResult($query);
				case "wddx":
					return $this->getResult($query,'wddx');
				case "xml":
					return $this->getResult($query,'xml');
			}
		}
		/**
		 * Busca Chats em aberto
		 */
		function get_chat($arguments=array(),$resulttype='array') {
			$query = 
				   'select c.chat_id, to_char(c.data_abertura,\'dd/mm/yyyy hh:mi\') as data_abertura, 
						   c.cliente_id, c.aberto_por, re.nome as aberto_por_nome, 
						   c.atendido_por, ra.nome as atendido_por_nome,
						   c.status_id, 
						   c.tipo_chat_id,
						   re.nome || \' -> \' || ra.nome || \' aberto em: \' || to_char(c.data_abertura, \'dd/mm/yyyy hh:mi\') as descricao
					  from kmm.v$chat c
					 inner join kmm.v$recurso re
							 on re.recurso_id = c.aberto_por 
					 inner join kmm.v$recurso ra
							 on ra.recurso_id = c.atendido_por         
				   where 1=1 ';
			if(strlen(trim($arguments[chat_id])))
				$query .= ' and c.chat_id in ('.$arguments[chat_id] .')';
			if(strlen(trim($arguments[status_id])))
				$query .= ' and c.status_id in ('.$arguments[status_id] .')';
			if(strlen(trim($arguments[atendido_por])))
				$query .= ' and c.atendido_por = '.$arguments[atendido_por];
			if(strlen(trim($arguments[aberto_por])))
				$query .= ' and c.aberto_por = '.$arguments[aberto_por];
			if(strlen(trim($arguments[recurso_id])))
				$query .= ' and (c.aberto_por = '.$arguments[recurso_id] . ' or c.atendido_por = ' .$arguments[recurso_id] .')';
			$query .= ' order by c.data_abertura ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			switch($resulttype) {	
				case "array":
				    return $this->getResult($query);
				case "wddx":
					return $this->getResult($query,'wddx');
				case "xml":
					return $this->getResult($query,'xml');
			}
		}
		/**
		 * Busca Mensagens
		 */
		function get_chat_mensagem($arguments=array(),$resulttype='array') {
			$query = 
			' select c.data_abertura, 
				     cm.mensagem_id, cm.chat_id, cm.data,
				     cm.enviada_por, cm.texto, r.nome as enviado_por_nome
			    from kmm.v$chat_mensagem cm
			   inner join kmm.v$chat c
				  	   on c.chat_id = cm.chat_id   			 
			   inner join kmm.v$recurso r
			           on r.recurso_id = cm.enviada_por
			   where 1=1 ';
			if(strlen(trim($arguments[chat_id])))
				$query .= ' and c.chat_id = '.$arguments[chat_id];
			if(strlen(trim($arguments[ultima_mensagem])))
				$query .= ' and cm.mensagem_id > '.$arguments[ultima_mensagem];
			if(strlen(trim($arguments[mensagem_id])))
				$query .= ' and cm.mensagem_id = '.$arguments[mensagem_id];
			$query .= ' order by cm.data ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			switch($resulttype) {	
				case "array":
				    return $this->getResult($query);
				case "wddx":
					return $this->getResult($query,'wddx');
				case "xml":
					return $this->getResult($query,'xml');
			}
		}
	}
	$ChatComObj = new ChatCom($_SESSION["conexao"]);
}

global $createdObject;
$createdObject = $ChatComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>