<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $CepComObj;
if(!$CepComObj) {
	class CepCom extends QueryCom {
		/**
		 * Busca os dados do municipio para a busca no INPE
		 */
		function get_municipio($arguments=array(),$resulttype='array') {
			$query = 
			' select t.municipio_id,
					 t.municipio,
					 t.uf_id as uf, 
					 t.cod_inpe,
					 p.descricao as pais,
					 oper.pkg_coord_geografica.fnc_graus2decimais(t.latitude) as latitude,
					 oper.pkg_coord_geografica.fnc_graus2decimais(t.longitude) as longitude,
					 t.altitude
			    from cep.municipio t
			   inner join cep.pais p
			           on p.pais_id = t.pais_id
			   where 1=1 ';
			if(strlen(trim($arguments[municipio])))
				$query .= ' and upper(kss.pkg_string.fnc_string_clean(t.municipio)) like upper(kss.pkg_string.fnc_string_clean(\'%'.$arguments[municipio].'%\')) ';
			if(strlen(trim($arguments[uf])))
				$query .= ' and upper(kss.pkg_string.fnc_string_clean(t.uf_id)) like upper(kss.pkg_string.fnc_string_clean(\'%'.$arguments[uf].'%\')) ';
			$query .= ' order by t.municipio ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			switch($resulttype) {	
				case "array":
				    return $this->getResult($query);
				case "wddx":
					return $this->getResult($query,'wddx');
			}
		}
		/**
		 * Busca o Endereco pelo CEP
		 */
		function get_endereco_cep($arguments=array(),$resulttype='array') {
			$query = '
				select m.municipio_id, log.cep8_log as cep,            
					   initcap(tit.abrev_tipo || \'.\' || \'  \' || log.nome_log) as logradouro,            
					   initcap(decode(loc.tipo_local, \'D\', \'Dist. \' || initcap(loc.nome_local),  
					   decode(loc.tipo_local,\'P\', \'Pov. \' || initcap(loc.nome_local) , 
					   initcap(bai.extenso_bai)))) as bairro,            
					   initcap(bai2.extenso_bai) as bairro2,            
					   m.municipio as local,            
					   uf.sigla_uf as uf, loc.cod_uf, 
					   loc.cod_municipio, loc.cod_distrito, loc.cod_dv
				  from cep.cep_log log
				 inner join cep.cep_tit tit
						 on log.chave_tipo = tit.chave_tipo
				 inner join cep.cep_bai bai
						 on log.chvbai1_log = bai.chave_bai
						and log.chave_local = bai.chave_local
				 inner join cep.cep_loc loc
						 on log.chave_local = loc.chave_local     
				 inner join cep.cep_ufs uf
						 on loc.sigla_uf = uf.sigla_uf     
				  left join cep.cep_bai bai2
						 on log.chvbai2_log = bai2.chave_bai
						and log.chave_local = bai2.chave_local
                 left join cep.municipio m
						 on loc.municipio_id_kmm = m.municipio_id 
				 where log.cep8_log = '.$arguments[cep].'
				union          
				select m.municipio_id, decode(loc.sit_local,\'0\', loc.cep8_local, log.cep8_log)  as cep,             
					   decode(loc.sit_local,\'0\', \'No codificado - Preencha com seu logradouro\',  log.nome_log )  as logradouro,             
					   decode(loc.tipo_local, \'D\', \'DIST. \' || loc.nome_local,  decode(loc.tipo_local,\'P\', \'POV. \' || loc.nome_local , 
					   bai.extenso_bai)) as bairro,             
					   initcap(bai2.extenso_bai),             
					   m.municipio as local,             
					   uf.sigla_uf as uf, 
					   loc.cod_uf, 
					   loc.cod_municipio, 
					   loc.cod_distrito, 
					   loc.cod_dv
				  from cep.cep_loc loc
				 inner join cep.cep_ufs uf
						 on loc.sigla_uf = uf.sigla_uf       
				  left join cep.cep_loc loc2
						 on loc.subor_local =  loc2.chave_local
				  left join cep.cep_log log 
						 on loc.chave_local =  log.chave_local
				  left join cep.cep_bai bai 
						 on log.chvbai1_log  =  bai.chave_bai
						and log.chave_local = bai.chave_local
				  left join cep.cep_bai bai2
						 on log.chvbai2_log  =  bai2.chave_bai
						and log.chave_local = bai2.chave_local
                  left join cep.municipio m
						 on loc.municipio_id_kmm = m.municipio_id 
				where loc.cep8_local = '.$arguments[cep].'
				union    
				select m.municipio_id, esp.cep8_esp as cep,            
					   initcap(esp.nome_esp || esp.comple_esp) as logradouro,            
					   initcap(bai.extenso_bai) as bairro,            
					   m.municipio as local,            
					   initcap(bai.extenso_bai) as bairro,            
					   esp.uf_esp as uf, 
					   loc.cod_uf, 
					   loc.cod_municipio, 
					   loc.cod_distrito, 
					   loc.cod_dv
				  from cep.cep_loc loc
				 inner join cep.cep_esp esp
						 on esp.chave_local = loc.chave_local     
				 inner join cep.cep_bai bai
						 on esp.chave_bai = bai.chave_bai     
						and esp.chave_local = bai.chave_local
                 inner join cep.municipio m
						 on loc.municipio_id_kmm = m.municipio_id 
				 where esp.cep8_esp = '.$arguments[cep].'
				union    
				select m.municipio_id, 
					   agp.cep8_agp as cep,            
					   initcap(agp.nome_agp) as logradouro,            
					   initcap(bai.extenso_bai) as bairro,            
					   m.municipio as local,            
					   initcap(bai.extenso_bai) as bairro,            
					   agp.uf_agp as uf, 
					   loc.cod_uf, 
					   loc.cod_municipio, 
					   loc.cod_distrito, 
					   loc.cod_dv
				  from cep.cep_loc loc
				 inner join cep.cep_agp agp
						 on agp.chave_local = loc.chave_local     
				 inner join cep.cep_bai bai
						 on agp.chave_bai = bai.chave_bai     
						and agp.chave_local = bai.chave_local 
                 inner join cep.municipio m
						 on loc.municipio_id_kmm = m.municipio_id 
				 where agp.cep8_agp = '.$arguments[cep].'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
	}
	$CepComObj = new CepCom($_SESSION["conexao"]);
}

global $createdObject;
$createdObject = $CepComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>