/*
 * Decompiled with CFR 0.152.
 */
package kmm.impressao.xml;

import java.awt.Graphics;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kmm.impressao.xml.PrintNode;
import kmm.impressao.xml.PrintNodeText;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReader {
    private ArrayList<PrintNode> nodes = new ArrayList();
    private float width;
    private float height;
    private int measure;
    private final int FROMFILE = 0;
    private final int FROMURL = 1;
    private final int FROMXML = 2;
    private int xmlOrigin = -1;
    private String url = "";
    private String xml;
    private File file = null;

    public XMLReader(File file) {
        this();
        this.xmlOrigin = 0;
        this.file = file;
        this.reload();
    }

    public XMLReader(String url) {
        this();
        this.xmlOrigin = 1;
        this.url = url;
        this.reload();
    }

    public XMLReader(String xml, boolean fromFile) {
        this();
        this.xmlOrigin = 2;
        this.xml = xml;
        this.reload();
    }

    private XMLReader() {
    }

    public float getHeight() {
        if (this.height == 0.0f) {
            return 500.0f;
        }
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getWidth() {
        if (this.width == 0.0f) {
            return 500.0f;
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getMeasure() {
        return this.measure;
    }

    public void setMeasure(int measure) {
        this.measure = measure;
    }

    public void reload() {
        this.nodes.clear();
        try {
            float widthTemp = 0.0f;
            float heightTemp = 0.0f;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilderFactory.setExpandEntityReferences(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            Document d = null;
            switch (this.xmlOrigin) {
                case 0: {
                    d = docBuilder.parse(this.file);
                    break;
                }
                case 1: {
                    d = docBuilder.parse(this.url);
                    break;
                }
                case 2: {
                    d = docBuilder.parse(new InputSource(new StringReader(this.xml)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Tipo de arquivo n\u00e3o suportado.");
                }
            }
            d.getDocumentElement().normalize();
            PrintNodeText pNode = new PrintNodeText();
            this.setMeasure(Integer.parseInt(d.getDocumentElement().getAttribute("measure")));
            widthTemp = pNode.convert(Float.parseFloat(d.getDocumentElement().getAttribute("width")), this.getMeasure());
            heightTemp = pNode.convert(Float.parseFloat(d.getDocumentElement().getAttribute("height")), this.getMeasure());
            this.setWidth(Math.round(widthTemp));
            this.setHeight(Math.round(heightTemp));
            NodeList nodeList = d.getElementsByTagName("campo");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.nodes.add(new PrintNodeText(nodeList.item(i), this.getMeasure()));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(XMLReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList<PrintNode> getNodes() {
        return this.nodes;
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.getNodes().size(); ++i) {
            this.getNodes().get(i).draw(g);
        }
    }
}

