/*
 * Decompiled with CFR 0.152.
 */
package kmm.impressao.xml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import kmm.impressao.xml.PrintNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PrintNodeText
implements PrintNode {
    public float left;
    public float top;
    public String conteudo;
    public String fontFamily;
    public int fontSize;
    public float width;
    public float height;
    public String align;
    private Font font;
    private int measure;
    public static final int PIXELTOPOINT = 2;
    public static final int MMTOPOINT = 3;

    public PrintNodeText() {
        this.height = 0.0f;
        this.width = 0.0f;
    }

    public PrintNodeText(float left, float top, String conteudo, String font_family, int font_size, int width, String align) {
        this();
        this.left = left;
        this.top = top;
        this.conteudo = conteudo.replaceAll("||", "\n");
        this.fontFamily = font_family;
        this.fontSize = font_size;
        this.width = width;
        this.align = align;
        this.setFont(this.fontFamily, this.fontSize);
    }

    public PrintNodeText(Node node) {
        this();
        Element elm = (Element)node;
        this.left = Integer.parseInt(elm.getAttribute("left"));
        this.top = Integer.parseInt(elm.getAttribute("top"));
        this.conteudo = elm.getTextContent().replace("||", "\n");
        this.fontFamily = elm.getAttribute("font_family");
        this.fontSize = Integer.parseInt(elm.getAttribute("font_size"));
        this.width = Integer.parseInt(elm.getAttribute("width"));
        if (elm.getAttribute("height") != null && !elm.getAttribute("height").isEmpty()) {
            this.height = Integer.parseInt(elm.getAttribute("height"));
        }
        this.align = elm.getAttribute("align");
        this.setFont(this.fontFamily, this.fontSize);
    }

    public PrintNodeText(Node node, int measure) {
        Element elm = (Element)node;
        this.left = Integer.parseInt(elm.getAttribute("left"));
        this.top = Integer.parseInt(elm.getAttribute("top"));
        this.conteudo = elm.getTextContent().replace("||", "\n");
        this.fontFamily = elm.getAttribute("font_family");
        this.fontSize = Integer.parseInt(elm.getAttribute("font_size"));
        this.width = Integer.parseInt(elm.getAttribute("width"));
        if (elm.getAttribute("height") != null && !elm.getAttribute("height").isEmpty()) {
            this.height = Integer.parseInt(elm.getAttribute("height"));
        }
        this.align = elm.getAttribute("align");
        this.setFont(this.fontFamily, this.fontSize);
        this.setMeasure(measure);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFont(String fontFamily, int fontSize) {
        this.setFont(new Font(fontFamily, 0, fontSize));
    }

    public int getMeasure() {
        return this.measure;
    }

    public void setMeasure(int measure) {
        this.measure = measure;
    }

    public void draw(Graphics g) {
        g.setFont(this.getFont());
        FontMetrics fm = g.getFontMetrics(this.getFont());
        float boxTop = this.convert(this.top, this.getMeasure());
        String texto = "";
        float pixelWidth = this.convert(this.width, this.getMeasure());
        float pixelHeight = this.convert(this.height, this.getMeasure());
        float heightLimit = boxTop + pixelHeight;
        for (int i = 0; i < this.conteudo.split("\n").length; ++i) {
            int limit;
            texto = this.conteudo.split("\n")[i];
            float boxLeft = this.left;
            for (limit = 1; limit < texto.length() && (float)fm.stringWidth(texto.substring(0, limit)) < pixelWidth; ++limit) {
            }
            if (texto.length() > 0 && pixelWidth > 0.0f) {
                texto = texto.substring(0, limit);
            }
            if ("right".equals(this.align)) {
                boxLeft = this.left + pixelWidth - (float)fm.stringWidth(texto);
            }
            boxLeft = this.convert(boxLeft, this.getMeasure());
            if (this.height > 0.0f && (boxTop += (float)fm.getAscent()) > heightLimit + (float)fm.getAscent()) break;
            g.drawString(texto, Math.round(boxLeft), Math.round(boxTop));
        }
    }

    protected float convert(float value, int measure) {
        float convertedValue = measure;
        switch (measure) {
            case 2: {
                convertedValue = this.pixelToPoint(value);
                break;
            }
            case 3: {
                convertedValue = this.mmToPoint(value);
                break;
            }
            default: {
                convertedValue = measure;
            }
        }
        return convertedValue;
    }

    private float pixelToPoint(float pixel) {
        float result = (float)((double)pixel * 1.33);
        return result;
    }

    private float pointToPixel(float point) {
        float result = (float)((double)point / 1.33);
        return result;
    }

    private float mmToPoint(float mm) {
        float result = (float)((double)mm * 2.834645669);
        return result;
    }
}

