/*
 * Decompiled with CFR 0.152.
 */
package kmm.impressao.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import kmm.impressao.preview.PrinterPreviewListener;
import kmm.impressao.printer.DocumentPrinter;
import kmm.impressao.xml.XMLReader;

public class PrintPreview
extends JFrame {
    private XMLReader xmlReader;
    private JPanel jPanelDocumento;
    private PrinterPreviewListener listener;
    private JButton jButtonAtualizar;
    private JButton jButtonImprimir;
    private JPanel jPanelPreview;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBarImpressao;

    public PrintPreview(XMLReader xmlReader, PrinterPreviewListener listener) {
        this.initComponents();
        this.xmlReader = xmlReader;
        this.listener = listener;
        this.jPanelDocumento = new JPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                PrintPreview.this.getXmlReader().draw(g);
            }
        };
        this.setTitle("KMM - Impress\u00e3o de formul\u00e1rios");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/kmm/impressao/resources/kmm.png")).getImage());
        this.jPanelDocumento.setBackground(new Color(255, 255, 255));
        this.jPanelDocumento.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout jPanelDocumentoLayout = new GroupLayout(this.jPanelDocumento);
        this.jPanelDocumento.setLayout(jPanelDocumentoLayout);
        jPanelDocumentoLayout.setHorizontalGroup(jPanelDocumentoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, Math.round(xmlReader.getWidth()), Short.MAX_VALUE));
        jPanelDocumentoLayout.setVerticalGroup(jPanelDocumentoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, Math.round(xmlReader.getHeight()), Short.MAX_VALUE));
        GroupLayout jPanelPreviewLayout = new GroupLayout(this.jPanelPreview);
        this.jPanelPreview.setLayout(jPanelPreviewLayout);
        jPanelPreviewLayout.setHorizontalGroup(jPanelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPreviewLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelDocumento, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelPreviewLayout.setVerticalGroup(jPanelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPreviewLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanelDocumento, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            PrintPreview.this.print();
                            PrintPreview.this.requestFocus();
                        }
                        catch (InterruptedException ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage());
                        }
                    }
                }.start();
            }
        });
    }

    public void print() {
        if (new DocumentPrinter(this.xmlReader).print(this) && this.listener.hasConfirmation() && JOptionPane.showConfirmDialog(this, this.listener.getConfirmationString(), "Confirma\u00e7\u00e3o", 0, 3) == 0) {
            this.listener.confirmPrint();
        }
    }

    private XMLReader getXmlReader() {
        return this.xmlReader;
    }

    private void initComponents() {
        this.jToolBarImpressao = new JToolBar();
        this.jButtonImprimir = new JButton();
        this.jButtonAtualizar = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelPreview = new JPanel();
        this.setDefaultCloseOperation(2);
        this.jToolBarImpressao.setFloatable(false);
        this.jButtonImprimir.setIcon(new ImageIcon(this.getClass().getResource("/kmm/impressao/imagens/imprimir.gif")));
        this.jButtonImprimir.setText("Imprimir");
        this.jButtonImprimir.setToolTipText("Imprimir");
        this.jButtonImprimir.setFocusable(false);
        this.jButtonImprimir.setHorizontalTextPosition(0);
        this.jButtonImprimir.setVerticalTextPosition(3);
        this.jButtonImprimir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintPreview.this.jButtonImprimirActionPerformed(evt);
            }
        });
        this.jToolBarImpressao.add(this.jButtonImprimir);
        this.jButtonAtualizar.setIcon(new ImageIcon(this.getClass().getResource("/kmm/impressao/imagens/atualizar.gif")));
        this.jButtonAtualizar.setText("Atualizar");
        this.jButtonAtualizar.setToolTipText("Atualizar dados do formul\u00e1rio");
        this.jButtonAtualizar.setFocusable(false);
        this.jButtonAtualizar.setHorizontalTextPosition(0);
        this.jButtonAtualizar.setVerticalTextPosition(3);
        this.jButtonAtualizar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintPreview.this.jButtonAtualizarActionPerformed(evt);
            }
        });
        this.jToolBarImpressao.add(this.jButtonAtualizar);
        this.getContentPane().add((Component)this.jToolBarImpressao, "First");
        this.jPanelPreview.setBackground(new Color(102, 102, 102));
        this.jPanelPreview.setMinimumSize(new Dimension(300, 300));
        GroupLayout jPanelPreviewLayout = new GroupLayout(this.jPanelPreview);
        this.jPanelPreview.setLayout(jPanelPreviewLayout);
        jPanelPreviewLayout.setHorizontalGroup(jPanelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 879, Short.MAX_VALUE));
        jPanelPreviewLayout.setVerticalGroup(jPanelPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 554, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelPreview);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 789) / 2, (screenSize.height - 542) / 2, 789, 542);
    }

    private void jButtonImprimirActionPerformed(ActionEvent evt) {
        this.print();
    }

    private void jButtonAtualizarActionPerformed(ActionEvent evt) {
        this.xmlReader.reload();
        this.jPanelDocumento.repaint();
    }
}

