/*
 * Decompiled with CFR 0.152.
 */
package kmm.launcher.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateDownloader {
    private String host;
    private File installLocation;

    public UpdateDownloader(String host, File installLocation) {
        this.host = host;
        this.installLocation = installLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException, SAXException, ParserConfigurationException {
        int len;
        byte[] buf;
        FileInputStream fis;
        int i;
        ArrayList<DownloadFile> files = this.getDownloadFiles();
        for (i = 0; i < files.size(); ++i) {
            files.get(i).setDownloadedFile(this.getFile(files.get(i).getVersaoId()));
        }
        for (i = 0; i < files.size(); ++i) {
            files.get(i).getFile(this.installLocation).getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(files.get(i).getFile(this.installLocation));
            try {
                FileInputStream is = new FileInputStream(files.get(i).getDownloadedFile());
                try {
                    int len2;
                    byte[] buf2 = new byte[1024];
                    while ((len2 = ((InputStream)is).read(buf2)) != -1) {
                        fos.write(buf2, 0, len2);
                    }
                    continue;
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            finally {
                fos.close();
            }
        }
        FileOutputStream fos = new FileOutputStream(new File(this.installLocation, "tnsnames.ora"));
        try {
            fis = new FileInputStream(this.getTnsNames());
            try {
                buf = new byte[1024];
                while ((len = fis.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        fos = new FileOutputStream(new File(this.installLocation, "config.xml"));
        try {
            fis = new FileInputStream(this.getConfig());
            try {
                buf = new byte[1024];
                while ((len = fis.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
    }

    private ArrayList<DownloadFile> getDownloadFiles() throws IOException, SAXException, ParserConfigurationException {
        ArrayList<DownloadFile> files = this.getFiles();
        for (int i = files.size() - 1; i >= 0; --i) {
            if (!this.validateFile(files.get(i))) continue;
            files.remove(i);
        }
        return files;
    }

    private boolean validateFile(DownloadFile file) {
        File f = file.getFile(this.installLocation);
        if (!f.exists()) {
            return false;
        }
        try {
            if (!this.md5(new FileInputStream(f)).equalsIgnoreCase(file.getMd5())) {
                return false;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger("KMMLauncher").log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private ArrayList<DownloadFile> getFiles() throws IOException, SAXException, ParserConfigurationException {
        ArrayList<DownloadFile> files = new ArrayList<DownloadFile>();
        StringBuilder sb = this.getFilesXMLString();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sb.toString().getBytes()));
            NodeList versionsNode = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < versionsNode.getLength(); ++i) {
                if (versionsNode.item(i).getNodeType() != 1) continue;
                Node versionNode = versionsNode.item(i);
                DownloadFile file = new DownloadFile();
                for (int j = 0; j < versionNode.getChildNodes().getLength(); ++j) {
                    if (versionNode.getChildNodes().item(j).getNodeType() != 1) continue;
                    if (versionNode.getChildNodes().item(j).getNodeName().equals("versao_id")) {
                        file.setVersaoId(Integer.parseInt(versionNode.getChildNodes().item(j).getTextContent()));
                    }
                    if (versionNode.getChildNodes().item(j).getNodeName().equals("path")) {
                        file.setPath(versionNode.getChildNodes().item(j).getTextContent());
                    }
                    if (versionNode.getChildNodes().item(j).getNodeName().equals("nome_arquivo")) {
                        file.setNomeArquivo(versionNode.getChildNodes().item(j).getTextContent());
                    }
                    if (!versionNode.getChildNodes().item(j).getNodeName().equals("md5")) continue;
                    file.setMd5(versionNode.getChildNodes().item(j).getTextContent());
                }
                files.add(file);
            }
            return files;
        }
        catch (ParserConfigurationException ex) {
            System.out.println(sb.toString());
            Logger.getLogger("KMMLauncher").log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (SAXException ex) {
            System.out.println(sb.toString());
            Logger.getLogger("KMMLauncher").log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    private StringBuilder getFilesXMLString() throws IOException {
        URL url = new URL(this.host + "/modulos/kmmupdate/updater.php");
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        conn.connect();
        HashMap<String, String> params = this.createParamsMap();
        params.put("operation", "getFiles");
        params.put("cod_aplicacao", "CORPORATIVO");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write(this.toPostParameters(params));
        writer.flush();
        InputStream is = conn.getInputStream();
        StringBuilder sb = new StringBuilder();
        int len = 0;
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            sb.append(new String(buf, 0, len));
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(int versaoId) throws MalformedURLException, IOException {
        URL url = new URL(this.host + "/modulos/kmmupdate/updater.php");
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        conn.connect();
        HashMap<String, String> params = this.createParamsMap();
        params.put("operation", "getFile");
        params.put("versao_id", "" + versaoId);
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write(this.toPostParameters(params));
        writer.flush();
        String md5Original = conn.getHeaderField("md5");
        File result = File.createTempFile("update", ".tmp");
        InputStream is = conn.getInputStream();
        ZipInputStream zis = new ZipInputStream(is);
        zis.getNextEntry();
        try {
            FileOutputStream fos = new FileOutputStream(result);
            try {
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = zis.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            zis.close();
        }
        String md5Baixado = this.md5(new FileInputStream(result));
        if (!md5Baixado.equalsIgnoreCase(md5Original)) {
            throw new IOException("MD5 baixado n\u00e3o confere com o MD5 esperado: " + md5Baixado + " <> " + md5Original);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getConfig() throws MalformedURLException, IOException {
        URL url = new URL(this.host + "/modulos/kmmupdate/updater.php");
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        conn.connect();
        HashMap<String, String> params = this.createParamsMap();
        params.put("operation", "getConfig");
        params.put("cod_aplicacao", "CORPORATIVO");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write(this.toPostParameters(params));
        writer.flush();
        File result = File.createTempFile("update", ".tmp");
        InputStream is = conn.getInputStream();
        try {
            FileOutputStream fos = new FileOutputStream(result);
            try {
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            is.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getTnsNames() throws MalformedURLException, IOException {
        URL url = new URL(this.host + "/modulos/kmmupdate/updater.php");
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        conn.connect();
        HashMap<String, String> params = this.createParamsMap();
        params.put("operation", "getTns");
        params.put("cod_aplicacao", "CORPORATIVO");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write(this.toPostParameters(params));
        writer.flush();
        File result = File.createTempFile("update", ".tmp");
        InputStream is = conn.getInputStream();
        try {
            FileOutputStream fos = new FileOutputStream(result);
            try {
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            is.close();
        }
        return result;
    }

    private String toPostParameters(HashMap<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (String key : params.keySet()) {
            result.append("&").append(key).append("=").append(params.get(key) == null ? "" : params.get(key));
        }
        return result.substring(1);
    }

    private HashMap<String, String> createParamsMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("internalpass", "kmmupdatepass");
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String md5(InputStream is) {
        String output = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int read = 0;
            int offset = 0;
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
                offset += read;
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            output = bigInt.toString(16);
            while (output.length() < 32) {
                output = "0" + output;
            }
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            String string = "";
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Logger.getLogger("KMMUpdateAgent").log(Level.SEVERE, null, e);
            }
        }
        return output;
    }

    public static void main(String[] args) throws Exception {
        new UpdateDownloader("http://dsvritmo01.kmm.com.br", new File("c:\\teste")).update();
        Process p = Runtime.getRuntime().exec("java -jar C:\\teste\\KMMCorporativo.jar", null, new File("C:\\teste"));
        System.out.println(p.waitFor());
    }

    private class DownloadFile {
        private int versaoId;
        private String path;
        private String nomeArquivo;
        private String md5;
        private File downloadedFile;

        public int getVersaoId() {
            return this.versaoId;
        }

        public void setVersaoId(int versaoId) {
            this.versaoId = versaoId;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getNomeArquivo() {
            return this.nomeArquivo;
        }

        public void setNomeArquivo(String nomeArquivo) {
            this.nomeArquivo = nomeArquivo;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public File getDownloadedFile() {
            return this.downloadedFile;
        }

        public void setDownloadedFile(File downloadedFile) {
            this.downloadedFile = downloadedFile;
        }

        public File getFile(File installDir) {
            return new File(installDir, this.getPath() + File.separator + this.getNomeArquivo());
        }
    }
}

