/*
 * Decompiled with CFR 0.152.
 */
package kmm.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import kmm.launcher.params.ApplicationParams;
import kmm.launcher.update.UpdateDownloader;
import org.xml.sax.SAXException;

public class Launcher {
    private ApplicationParams parameters;

    public Launcher(ApplicationParams params) {
        this.parameters = params;
    }

    public ApplicationParams getParameters() {
        return this.parameters;
    }

    public void setParameters(ApplicationParams parameters) {
        this.parameters = parameters;
    }

    private File getDestinationDir() throws IOException {
        File f = File.createTempFile("tmp", "").getParentFile();
        String suffix = "fastExec-" + this.parameters.get("host").toString().replace(":", "").replace("/", "");
        File result = new File(f, suffix);
        return result;
    }

    public void start() throws IOException, SAXException, ParserConfigurationException {
        if (!this.parameters.containsKey("silent")) {
            throw new UnsupportedOperationException("Apenas o modo de execu\u00e7\u00e3o SILENT \u00e9 suportado");
        }
        File destination = this.getDestinationDir();
        UpdateDownloader up = new UpdateDownloader(this.parameters.get("host").toString(), destination);
        up.update();
        this.run(destination);
    }

    private void run(File destination) throws IOException {
        int len;
        ArrayList<String> ar = this.parameters.toStringArray();
        String comando = "java -Xmx1024m -jar \"" + destination.getAbsolutePath() + File.separator + "KMMCorporativo.jar\"";
        for (String string : ar) {
            comando = comando + " " + string;
        }
        Process p = Runtime.getRuntime().exec(comando, null, destination);
        InputStream is = p.getErrorStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            System.out.print(new String(buf, 0, len));
        }
        try {
            System.out.println("Exit: " + p.waitFor());
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

