/*
 * Decompiled with CFR 0.152.
 */
package kmm.chat;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import kmm.chat.ChatPrincipal;
import kmm.com.Chat;
import kmm.com.ChatMensagem;
import kmm.com.xml;

public class ChatTela
extends JFrame {
    private String v_url_principal = "http://tstcf8.kmm.com.br";
    private SimpleDateFormat ft = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    private String ls = System.getProperty("line.separator");
    private Chat ChatAtual = null;
    private ChatMensagem MensagemAtual = null;
    private int recurso_id_origem_mensagem;
    private JButton btn_enviar;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel pnl_conversacao;
    public JTextArea txt_conversacao;
    private JTextArea txt_mensagem;

    public ChatTela() {
        this.initComponents();
    }

    public ChatTela(Chat chat_atual, ChatMensagem mensagem_atual, int recurso_id_origem_mensagem, String url_principal) {
        this.ChatAtual = chat_atual;
        this.MensagemAtual = mensagem_atual == null ? new ChatMensagem(chat_atual.chat_id) : mensagem_atual;
        this.recurso_id_origem_mensagem = recurso_id_origem_mensagem;
        this.v_url_principal = url_principal;
        this.initComponents();
        this.inicia_conversacao();
    }

    private void initComponents() {
        this.pnl_conversacao = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txt_conversacao = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txt_mensagem = new JTextArea();
        this.btn_enviar = new JButton();
        this.setDefaultCloseOperation(3);
        this.pnl_conversacao.setBorder(BorderFactory.createTitledBorder("Conversa\u00e7\u00e3o aberta"));
        this.txt_conversacao.setColumns(20);
        this.txt_conversacao.setEditable(false);
        this.txt_conversacao.setRows(5);
        this.jScrollPane1.setViewportView(this.txt_conversacao);
        this.jLabel1.setText("Sua mensagem:");
        this.txt_mensagem.setColumns(20);
        this.txt_mensagem.setRows(5);
        this.jScrollPane2.setViewportView(this.txt_mensagem);
        this.btn_enviar.setText("Enviar");
        this.btn_enviar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatTela.this.btn_enviarActionPerformed(evt);
            }
        });
        GroupLayout pnl_conversacaoLayout = new GroupLayout(this.pnl_conversacao);
        this.pnl_conversacao.setLayout(pnl_conversacaoLayout);
        pnl_conversacaoLayout.setHorizontalGroup(pnl_conversacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 368, Short.MAX_VALUE).addGroup(pnl_conversacaoLayout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap()).addComponent(this.jScrollPane2, -1, 368, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnl_conversacaoLayout.createSequentialGroup().addContainerGap().addComponent(this.btn_enviar)));
        pnl_conversacaoLayout.setVerticalGroup(pnl_conversacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_conversacaoLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 409, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.btn_enviar)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnl_conversacao, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnl_conversacao, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void btn_enviarActionPerformed(ActionEvent evt) {
        try {
            Date dt = new Date();
            ChatMensagem chat_mensagem = new ChatMensagem(this.ChatAtual.chat_id, this.ft.format(dt), this.recurso_id_origem_mensagem, this.txt_mensagem.getText(), "");
            chat_mensagem.gravaMensagem(this.v_url_principal + "/_webservices/chat/chat.php?operacao=ins_chat_mensagem&" + chat_mensagem.queryString(), chat_mensagem);
            xml.Registro mensagem = this.buscaMensagem(chat_mensagem.mensagem_id);
            this.MensagemAtual.mensagem_id = chat_mensagem.mensagem_id;
            this.txt_conversacao.append(this.ls);
            this.txt_conversacao.append(mensagem.getAtributo("ENVIADO_POR_NOME") + ": " + mensagem.getConteudo());
            this.txt_mensagem.setText("");
        }
        catch (ParseException ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Object[] buscaMensagens(int chat_id, int mensagem_id) throws Exception {
        xml qrMensagens = new xml(this.v_url_principal + "/_webservices/chat/chat.php?operacao=get_chat_mensagem&ultima_mensagem=" + mensagem_id + "&chat_id=" + chat_id);
        Object[] mensagens = qrMensagens.busca_registro(qrMensagens.elem.getElementsByTagName("row"), "MENSAGEM_ID", "TEXTO", "DATA,ENVIADO_POR,ENVIADO_POR_NOME");
        return mensagens;
    }

    public xml.Registro buscaMensagem(int mensagem_id) throws Exception {
        xml qrMensagens = new xml(this.v_url_principal + "/_webservices/chat/chat.php?operacao=get_chat_mensagem&mensagem_id=" + mensagem_id);
        Object[] mensagens = qrMensagens.busca_registro(qrMensagens.elem.getElementsByTagName("row"), "MENSAGEM_ID", "TEXTO", "DATA,ENVIADO_POR,ENVIADO_POR_NOME");
        xml.Registro mensagem = (xml.Registro)mensagens[0];
        return mensagem;
    }

    public void inicia_conversacao() {
        this.atualizaConversacao(this.ChatAtual.chat_id, 0);
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatTela.this.atualizaConversacao(((ChatTela)ChatTela.this).ChatAtual.chat_id, ((ChatTela)ChatTela.this).MensagemAtual.mensagem_id);
            }
        };
        Timer t = new Timer(4000, action);
        t.start();
    }

    public void atualizaConversacao(int chat_id, int mensagem_id) {
        try {
            Object[] mensagens = this.buscaMensagens(chat_id, mensagem_id);
            for (int i = 0; i < mensagens.length; ++i) {
                xml.Registro mensagem = (xml.Registro)mensagens[i];
                this.MensagemAtual.mensagem_id = mensagem.getId();
                this.txt_conversacao.append(this.ls);
                this.txt_conversacao.append(mensagem.getAtributo("ENVIADO_POR_NOME") + ": " + mensagem.getConteudo());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ChatTela().setVisible(true);
            }
        });
    }
}

