/*
 * Decompiled with CFR 0.152.
 */
package kmm.chat;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import kmm.chat.ChatTela;
import kmm.com.Chat;
import kmm.com.ChatMensagem;
import kmm.com.xml;

public class ChatPrincipal
extends JApplet {
    private String v_url_principal = "http://tstcf8.kmm.com.br";
    private SimpleDateFormat ft = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    private String ls = System.getProperty("line.separator");
    private int recurso_id_origem_mensagem;
    public Chat ChatAtual = new Chat();
    private JButton btn_conectar;
    private JButton btn_enviar;
    private JButton btn_fecha_erro;
    private JButton btn_reabrir;
    private JComboBox cmb_aberto_por;
    private JDialog dlg_mensagem_erro;
    private JFrame frm_chat;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JLabel lb_conversar_com;
    private JLabel lb_nome;
    private JLabel lbl_mensagem_erro;
    private JList lst_chat_aberto;
    private JList lst_recurso_id;
    private JPanel pnl_conversacao;
    private JScrollPane pnl_sql_erro;
    private JTabbedPane tab_msg_erro;
    private JTextArea txt_conversacao;
    private JTextArea txt_mensagem;
    private JTextArea txt_msg_erro;
    private JTextArea txt_sql_erro;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        ChatPrincipal.this.initComponents();
                        System.out.println(ChatPrincipal.this.getCodeBase());
                        xml qrRecursos = new xml(ChatPrincipal.this.v_url_principal + "/_webservices/chat/chat.php?operacao=get_recursos&tecnico=1");
                        Object[] recursos = qrRecursos.busca_registro(qrRecursos.elem.getElementsByTagName("row"), "RECURSO_ID", "NOME_COMPLETO", "CLIENTE_ID");
                        ChatPrincipal.this.lst_recurso_id.setListData(recursos);
                        for (int i = 0; i < recursos.length; ++i) {
                            ChatPrincipal.this.cmb_aberto_por.addItem(recursos[i]);
                        }
                        ChatPrincipal.this.cmb_aberto_por.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                try {
                                    xml.Registro recurso = (xml.Registro)ChatPrincipal.this.cmb_aberto_por.getSelectedItem();
                                    ChatPrincipal.this.ChatAtual.aberto_por = recurso.getId();
                                    ChatPrincipal.this.atualizaChats(ChatPrincipal.this.ChatAtual.aberto_por);
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Chat buscaChat(int chat_id) throws Exception {
        xml qrChats = new xml(this.v_url_principal + "/_webservices/chat/chat.php?operacao=get_chat&chat_id=" + chat_id);
        Object[] chats = qrChats.busca_registro(qrChats.elem.getElementsByTagName("row"), "CHAT_ID", "DESCRICAO", "ABERTO_POR_NOME,ABERTO_POR,ATENDIDO_POR_NOME,ATENDIDO_POR,DATA_ABERTURA,STATUS_ID,TIPO_CHAT_ID");
        xml.Registro chat = (xml.Registro)chats[0];
        Chat v_chat = new Chat(chat.getId(), chat.getAtributo("DATA_ABERTURA"), chat.getAtributoInt("CLIENTE_ID"), chat.getAtributoInt("ABERTO_POR"), chat.getAtributoInt("ATENDIDO_POR"), chat.getAtributoInt("STATUS_ID"), chat.getAtributoInt("TIPO_CHAT_ID"));
        return v_chat;
    }

    public Object[] buscaChatsAbertos(int recurso_id) throws Exception {
        xml qrChats = new xml(this.v_url_principal + "/_webservices/chat/chat.php?operacao=get_chat&recurso_id=" + recurso_id);
        Object[] chats = qrChats.busca_registro(qrChats.elem.getElementsByTagName("row"), "CHAT_ID", "DESCRICAO", "ABERTO_POR_NOME,ABERTO_POR,ATENDIDO_POR_NOME,ATENDIDO_POR,DATA_ABERTURA");
        return chats;
    }

    public void atualizaChats(int recurso_id) throws Exception {
        Object[] chats = this.buscaChatsAbertos(recurso_id);
        this.lst_chat_aberto.setListData(chats);
    }

    private void initComponents() {
        this.frm_chat = new JFrame();
        this.jLabel2 = new JLabel();
        this.pnl_conversacao = new JPanel();
        this.txt_conversacao = new JTextArea();
        this.jPanel4 = new JPanel();
        this.btn_enviar = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.txt_mensagem = new JTextArea();
        this.dlg_mensagem_erro = new JDialog();
        this.btn_fecha_erro = new JButton();
        this.lbl_mensagem_erro = new JLabel();
        this.tab_msg_erro = new JTabbedPane();
        this.jScrollPane5 = new JScrollPane();
        this.txt_msg_erro = new JTextArea();
        this.pnl_sql_erro = new JScrollPane();
        this.txt_sql_erro = new JTextArea();
        this.jPanel1 = new JPanel();
        this.lb_nome = new JLabel();
        this.btn_conectar = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lst_recurso_id = new JList();
        this.lb_conversar_com = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lst_chat_aberto = new JList();
        this.btn_reabrir = new JButton();
        this.cmb_aberto_por = new JComboBox();
        this.frm_chat.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ChatPrincipal.this.frm_chatComponentShown(evt);
            }
        });
        this.pnl_conversacao.setBorder(BorderFactory.createTitledBorder("Conversa\u00e7\u00e3o em aberta"));
        this.txt_conversacao.setColumns(20);
        this.txt_conversacao.setEditable(false);
        this.txt_conversacao.setRows(5);
        GroupLayout pnl_conversacaoLayout = new GroupLayout(this.pnl_conversacao);
        this.pnl_conversacao.setLayout(pnl_conversacaoLayout);
        pnl_conversacaoLayout.setHorizontalGroup(pnl_conversacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txt_conversacao, GroupLayout.Alignment.TRAILING, -1, 404, Short.MAX_VALUE));
        pnl_conversacaoLayout.setVerticalGroup(pnl_conversacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txt_conversacao, -1, 358, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Sua Mensagem"));
        this.btn_enviar.setText("Enviar");
        this.btn_enviar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatPrincipal.this.btn_enviarActionPerformed(evt);
            }
        });
        this.txt_mensagem.setColumns(20);
        this.txt_mensagem.setRows(5);
        this.jScrollPane4.setViewportView(this.txt_mensagem);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(337, Short.MAX_VALUE).addComponent(this.btn_enviar)).addComponent(this.jScrollPane4, -1, 400, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane4, -1, 67, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.btn_enviar)));
        GroupLayout frm_chatLayout = new GroupLayout(this.frm_chat.getContentPane());
        this.frm_chat.getContentPane().setLayout(frm_chatLayout);
        frm_chatLayout.setHorizontalGroup(frm_chatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frm_chatLayout.createSequentialGroup().addContainerGap().addGroup(frm_chatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnl_conversacao, -1, -1, Short.MAX_VALUE).addGroup(frm_chatLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        frm_chatLayout.setVerticalGroup(frm_chatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frm_chatLayout.createSequentialGroup().addContainerGap().addGroup(frm_chatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, frm_chatLayout.createSequentialGroup().addComponent(this.pnl_conversacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addContainerGap(20, Short.MAX_VALUE)));
        this.btn_fecha_erro.setText("jButton1");
        this.lbl_mensagem_erro.setText("jLabel4");
        this.txt_msg_erro.setColumns(20);
        this.txt_msg_erro.setRows(5);
        this.jScrollPane5.setViewportView(this.txt_msg_erro);
        this.tab_msg_erro.addTab("Mensagem", this.jScrollPane5);
        this.txt_sql_erro.setColumns(20);
        this.txt_sql_erro.setRows(5);
        this.pnl_sql_erro.setViewportView(this.txt_sql_erro);
        this.tab_msg_erro.addTab("SQL", this.pnl_sql_erro);
        GroupLayout dlg_mensagem_erroLayout = new GroupLayout(this.dlg_mensagem_erro.getContentPane());
        this.dlg_mensagem_erro.getContentPane().setLayout(dlg_mensagem_erroLayout);
        dlg_mensagem_erroLayout.setHorizontalGroup(dlg_mensagem_erroLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dlg_mensagem_erroLayout.createSequentialGroup().addContainerGap().addGroup(dlg_mensagem_erroLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dlg_mensagem_erroLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dlg_mensagem_erroLayout.createSequentialGroup().addComponent(this.tab_msg_erro, -1, 601, Short.MAX_VALUE).addContainerGap()).addGroup(dlg_mensagem_erroLayout.createSequentialGroup().addComponent(this.lbl_mensagem_erro).addContainerGap(577, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, dlg_mensagem_erroLayout.createSequentialGroup().addComponent(this.btn_fecha_erro).addContainerGap()))));
        dlg_mensagem_erroLayout.setVerticalGroup(dlg_mensagem_erroLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dlg_mensagem_erroLayout.createSequentialGroup().addContainerGap().addComponent(this.lbl_mensagem_erro).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tab_msg_erro, -1, 312, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_fecha_erro).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Recursos"));
        this.lb_nome.setText("Nome:");
        this.btn_conectar.setText("Conectar");
        this.btn_conectar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatPrincipal.this.btn_conectarActionPerformed(evt);
            }
        });
        this.lst_recurso_id.setVerifyInputWhenFocusTarget(false);
        this.lst_recurso_id.setVisibleRowCount(10);
        this.lst_recurso_id.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
                ChatPrincipal.this.lst_recurso_idCaretPositionChanged(evt);
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
            }
        });
        this.jScrollPane1.setViewportView(this.lst_recurso_id);
        this.lb_conversar_com.setText("Conversar com:");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Conversa\u00e7\u00f5es em aberto", 0, 4));
        this.lst_chat_aberto.setBackground(new Color(240, 240, 240));
        this.jScrollPane2.setViewportView(this.lst_chat_aberto);
        this.btn_reabrir.setText("Reabrir");
        this.btn_reabrir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatPrincipal.this.btn_reabrirActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.btn_reabrir)).addComponent(this.jScrollPane2, -1, 403, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 276, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btn_reabrir).addContainerGap()));
        this.cmb_aberto_por.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChatPrincipal.this.cmb_aberto_por_onchange(evt);
            }
        });
        this.cmb_aberto_por.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChatPrincipal.this.cmb_aberto_porActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 175, Short.MAX_VALUE).addComponent(this.lb_conversar_com)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lb_nome).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmb_aberto_por, 0, 478, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_conectar, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lb_nome).addComponent(this.cmb_aberto_por, -2, -1, -2).addComponent(this.btn_conectar)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lb_conversar_com).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 325, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btn_conectarActionPerformed(ActionEvent evt) {
        xml.Registro recurso = (xml.Registro)this.cmb_aberto_por.getSelectedItem();
        this.ChatAtual.aberto_por = recurso.getId();
        this.recurso_id_origem_mensagem = recurso.getId();
        try {
            this.ChatAtual.cliente_id = recurso.getAtributoInt("CLIENTE_ID");
        }
        catch (ParseException ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
        recurso = (xml.Registro)this.lst_recurso_id.getSelectedValue();
        this.ChatAtual.atendido_por = recurso.getId();
        this.ChatAtual = this.ChatAtual.gravaChat(this.v_url_principal + "/_webservices/chat/chat.php?operacao=ins_chat&" + this.ChatAtual.queryString(), this.ChatAtual);
        ChatTela conversa = new ChatTela(this.ChatAtual, null, this.recurso_id_origem_mensagem, this.v_url_principal);
        conversa.setVisible(true);
        conversa.setResizable(false);
        conversa.setSize(410, 600);
        conversa.txt_conversacao.setText("Conversa\u00e7\u00e3o aberta: " + this.ChatAtual.chat_id);
    }

    private void cmb_aberto_porActionPerformed(ActionEvent evt) {
    }

    private void cmb_aberto_por_onchange(ItemEvent evt) {
    }

    private void lst_recurso_idCaretPositionChanged(InputMethodEvent evt) {
    }

    private void frm_chatComponentShown(ComponentEvent evt) {
    }

    private void btn_enviarActionPerformed(ActionEvent evt) {
        try {
            Date dt = new Date();
            ChatMensagem chat_mensagem = new ChatMensagem(this.ChatAtual.chat_id, this.ft.format(dt), this.recurso_id_origem_mensagem, this.txt_mensagem.getText(), "");
            chat_mensagem.gravaMensagem(this.v_url_principal + "/_webservices/chat/chat.php?operacao=ins_chat_mensagem&" + chat_mensagem.queryString(), chat_mensagem);
            ChatTela conversa = new ChatTela(this.ChatAtual, chat_mensagem, this.recurso_id_origem_mensagem, this.v_url_principal);
            xml.Registro mensagem = conversa.buscaMensagem(chat_mensagem.mensagem_id);
            this.txt_conversacao.append(this.ls);
            this.txt_conversacao.append(mensagem.getAtributo("ENVIADO_POR_NOME") + ": " + mensagem.getConteudo());
            this.txt_mensagem.setText("");
        }
        catch (ParseException ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void btn_reabrirActionPerformed(ActionEvent evt) {
        try {
            xml.Registro chat_item = (xml.Registro)this.lst_chat_aberto.getSelectedValue();
            Chat v_chat = this.buscaChat(chat_item.getId());
            System.out.println(chat_item.getId());
            this.recurso_id_origem_mensagem = v_chat.aberto_por;
            ChatTela conversa = new ChatTela(v_chat, null, this.recurso_id_origem_mensagem, this.v_url_principal);
            conversa.setVisible(true);
            conversa.setResizable(false);
            conversa.setSize(410, 600);
            conversa.txt_conversacao.setText("Conversa\u00e7\u00e3o aberta: " + v_chat.chat_id);
        }
        catch (Exception ex) {
            Logger.getLogger(ChatPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

